/*
    This file is part of Funiter,
    Real and complex function iteration software.

    menutext.h - Funiter's default menu texts.
    
    Copyright (C) 1995-2010 Stijn Wolters.
    Original idea: Ernic Kamerich (University of Nijmegen).
    
    See README for contact information.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    See COPYING for more information.
*/

#ifndef __MENUTEXTS

    #define __MENUTEXTS

    #define SLA(V,W) ((Functiontype == FT_REAL) ? (RealExp->Settings->V = (W)) :\
                     (ComplexExp->Settings->V = (W)))

    #define SA(V)    ((Functiontype == FT_REAL) ? (RealExp->Settings->V) :\
                     (ComplexExp->Settings->V))
    
    #include <stdio.h>
    #include "estoui.h"

    extern char     *MenuTitleStrings[12];
    extern char     *MiscTexts[6];
    extern char     *FnHelpText[16];
    extern char     *CFnHelpText[4];
    extern char     *FnErrText[8];
    extern char     LicenseText[];
    extern char     *PullDownMenu[25];
    extern char     *EditColPalHelp[7];
    extern char     F1KeyStr[]; 
    extern char     CalcHelpStr[];
    extern char     *ZoomHelpStr[6];
    extern char     *RealComplexStepHelpStr[4];
    extern char     *ComplexStepInvHelpStr[7];
    extern char     *DefPointHelpStr[3];
    extern char     *DefShapeHelpStr[4];
    extern char     *RealJumpStr[3];
    extern char     *CplJumpHelpStr[6];
    extern char     *JuliaNoMemStr[];
        
    extern TItem    WizardItems[13];
    extern TItem    MainItems[13];
    extern TItem    RealGraphItems[3];
    extern TItem    ComplexGraphItems[5];
    extern TItem    RealDiagramItems[4];
    extern TItem    ComplexStepShapeItems[4];
    extern TItem    ComplexStepColorItems[3];
    extern TItem    ComplexDiagramItems[4];
    extern TItem    RealFnItems[7];
    extern TItem    ComplexFnItems[4];
    extern TItem    UserDefFnItems[2];
    extern TItem    ParameterItems[26];
    extern TItem    SettingsItems[5];
    extern TItem    LayoutItems[5];
    extern TItem    CoordItems[3];
    extern TItem    StepItems[4];
    extern TItem    ColorItems[7];
    extern TItem    EditColPalItems[8];
    extern TItem    FilesItems[4];
    extern TItem    RJItems[8];
    extern TItem    RJSItems[5];
    extern TItem    CJItems[8];
    extern TItem    CJSItems[3];
    extern TItem    CJSSItems[5];
    extern TItem    CJSCItems[4];
    extern TItem    CJOItems[7];
    extern TItem    CSItems[5];
#endif


