/*
    This file is part of Funiter,
    Real and complex function iteration software.

    estoui.h - Funiter's old menu routine.

    Copyright (C) 1995-2009 Stijn Wolters.
    Original idea: Ernic Kamerich (University of Nijmegen).
    
    See README for contact information.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    See COPYING for more information.


*/

#ifndef _ESTOUI
    #define _ESTOUI
    
    #define I_MENU                  0 
    #define I_EDIT                  1
    #define I_ITEM                  2
    
    #define M_STATUSBAR             3 
    #define M_HEADER                4 

    #define I_VISIBLE               5 
    #define I_ENABLED               6 
    #define I_SELECTED              7 
    #define I_CHANGED               8
    #define I_ENT_EDIT              9
    #define I_LEFT_EDIT             10
    
    #define E_NUM                   11
    #define E_FNUM                  12
    #define E_CHR                   13
    #define E_NUMCHR                14
    #define E_ASCII                 15
    
    #define MAX_EDIT_SPACE          100
    
    #include <stdio.h>
    #include <string.h>
    #include <ctype.h>
    #include "alconio.h"
    #include "bitmanip.h"
    
    typedef struct {
        char            *Caption, *Contents;
        unsigned int    XPos, YPos, Width, ContentsWidth, Height, Flag;
    } TItem;
    
    typedef struct {
        char            *Header;
        unsigned int    XPos, YPos, 
                        DefaultItemIndex, MaxItem, MaxItemWidth, ItemIndex, 
                        FgCol, BkCol, FgSelCol, BkSelCol, NumItem, Flag,
                        Key, AscKey;
        TItem           **Items;
    } TMenu;

    void DrawStatusBar(TConsole *Console, unsigned int Mode);
    void DrawCaption(TConsole *Console, int XPos, int YPos, char *CaptionStr);
    void DrawItemContents(TConsole *Console, TMenu *Menu, TItem *Item);
    void DrawItem(TConsole *Console, TMenu *Menu, TItem *Item);
    
    int SwapItemCaptions(char **Cap1, char **Cap2);

    int OpenLanguageFile(const char *Filename);
    void CloseLanguageFile(void);
    
    char **GetItemStrings(const char *Header, int *MenuWidth, 
        int *MaxItemLength, int MaxItemIndex);
    void DestroyItemStrings(char **ItemStrings, int MaxItemIndex);

    TItem *CreateItem(const char *Caption, const char *Contents, int XPos,
        int YPos, int Width, int Height, int Flag);
        void DestroyItem(TItem *Item);
    void DestroyItem(TItem *Item);

    TItem **CreateItems(const TItem *SrcItems, int NumItem);
    void DestroyItems(TItem **Items, int NumItem);

    TMenu *CreateMenu(const char *Header, int XPos, int YPos,
        int DefaultItemIndex, int MaxItem, int MaxItemWidth, int ItemIndex,
        int FgCol, int BkCol, int FgSelCol, int BkSelCol, int NumItem, int Flag,
        const TItem *Items);
    void DestroyMenu(TMenu *Menu);

    void DrawMenu(TConsole *Console, TMenu *Menu);
    int DoInput(TMenu *Menu, TItem *Item);
    int DoMenu(TConsole *Console, TMenu *Menu);

#endif
