/*
    This file is part of Funiter,
    Real and complex function iteration software.

    clsmenus.h - Funiter's classic menu-style routines.

    Copyright (C) 1995-2009 Stijn Wolters.
    Original idea: Ernic Kamerich (University of Nijmegen).

    See README for contact information.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    See COPYING for more information.
*/

#ifndef _CLSMENUS
    #define _CLSMENUS
    
    #include <stdio.h>
    #include <allegro.h>
#ifdef BUILD_WITH_ADIME
    #include <adime.h>
#endif
#ifdef BUILD_WITH_JPGALLEG
    #include <jpgalleg.h>
#endif
    #include "realexp.h"
    #include "cplexp.h"
    #include "alconio.h"
    #include "estoui.h"
    #include "cntmenu.h"
    #include "menutext.h"
    #include "misc.h"
        
    #define MS_STANDARD        TRUE
    #define MS_ADVANCED        FALSE

#ifdef BUILD_WITH_ADIME
#define FILE_SELECT_BOX     adime_file_select
#else
#define FILE_SELECT_BOX     file_select_ex
#endif

    int InitClassicMenus(int FnType, char *LngFilename);
    int ClsMnuMain(TConsole *Console, TRealExp *RealExp, 
        TComplexExp *ComplexExp, int DefaultItemIndex);
    int ClsMnuGraph(TConsole *Console, TRealExp *RealExp, 
        TComplexExp *ComplexExp);
    int ClsMnuDiagram(TConsole *Console, TRealExp *RealExp, 
        TComplexExp *ComplexExp);
    int ClsSubDiagram(TConsole *Console, TComplexExp *ComplexExp);
    int ClsMnuFunction(TConsole *Console, TRealExp *RealExp, 
        TComplexExp *ComplexExp);
    void UserDefFnMenu(TConsole *Console, TRealExp *RealExp, 
        TComplexExp *ComplexExp);
    int ClsMnuPar(TConsole *Console, TRealExp *RealExp, 
        TComplexExp *ComplexExp); 
    int ClsMnuDraw(TConsole *Console, TRealExp *RealExp, 
        TComplexExp *ComplexExp);
    void ClsMnuSettings(TConsole *Console,  TRealExp *RealExp, 
        TComplexExp *ComplexExp,int *ISet, int *ILay, int *ICoo, 
        int *IStep, int *ICol);
    void ClsMnuLayout(TConsole *Console,  TRealExp *RealExp,
        TComplexExp *ComplexExp,int *ILay, int *ICoo, int *IStep, int *ICol);
    int ClsMnuCoords(TConsole *Console, TRealExp *RealExp, 
        TComplexExp *ComplexExp, int ICoo);
    int ClsMnuStep(TConsole *Console, TRealExp *RealExp, 
        TComplexExp *ComplexExp, int IStep);
    int ClsMnuColors(TConsole *Console, TRealExp *RealExp, 
        TComplexExp *ComplexExp, int IColor);
    int ClsEditColorPalette(TConsole *Console, TRealExp *RealExp, 
        TComplexExp *ComplexExp);
    int ClsMnuFiles(TConsole *Console, TRealExp *RealExp, 
        TComplexExp *ComplexExp, int *ItemF);
    int ClsMnuAbout(TConsole *Console);
#endif
