/*
    This file is part of Funiter,
    Real and complex function iteration software.

    makedoc.c - make documentation.

    Copyright (C) 1995-2010 Stijn Wolters.
    Original idea: Ernic Kamerich (University of Nijmegen).
    
    See README for contact information.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    See COPYING for more information.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <allegro.h>


int WriteHeader(void);
int GenMainMenu(FILE *f_out, int Item);
int GenContents(FILE *f_out, int Item);
int GenFooter(FILE *f_out, AL_CONST char *footer_file);

int main(int argc, char **argv)
{
    if(argc < 2) {
        printf("Usage: %s <configuration file>.\n", argv[0]);
        return 0;
    }
    
    allegro_init();
    
    push_config_state();
    set_config_file(argv[1]);

    printf("Result: %2d pages generated.\n", WriteHeader());
    
    allegro_exit();
    return 0;
}
END_OF_MAIN()

int WriteHeader(void)
{
    FILE            *f_out;
    AL_CONST char   *css_file = get_config_string("main", "css", NULL),
                    *language = get_config_string("main", "language", "en"),
                    *footer = get_config_string("main", "footer", NULL),
                    *meta_desc = get_config_string("main", "meta_desc", NULL),
                    *meta_key = get_config_string("main", "meta_key", NULL),
                    *title = get_config_string("main", "title", NULL),
                    *subtitle_delim = get_config_string("main", "subtitle_delim",
                        " - "),
                    *subtitle, 
                    *destfile;
    char            Str[10];
    int             n;
                    
    for(n = 0; n <= 49; n++) {
        
        snprintf(Str, 7, "item%d", n);
        subtitle = get_config_string("outpages", Str, NULL);
        if(subtitle == NULL) break;
        
        snprintf(Str, 7, "file%d", n);
        destfile = get_config_string("outpages", Str, NULL);
        if(destfile == NULL) break;
        
        f_out = fopen(fix_filename_slashes((char *) destfile), "wt");
        if(f_out == NULL) break;
        
        /* Write doctype */
    
        fputs("<?xml version=\"1.0\"?>\n", f_out);
        fprintf(f_out, "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 ");
        fprintf(f_out, "Transitional//EN\"\n");
        fputs("    \"DTD/xhtml1-transitional.dtd\">\n", f_out);

        /* Write html */
    
        fprintf(f_out, "<html dir=\"ltr\" xml:lang=\"%s\" lang=\"%s\">\n\n", 
            language, language); 

        /* Write head */
    
        fputs("<head>\n", 
            f_out);
        fputs("    <meta http-equiv=\"content-type\" content=\"text/html; ", 
            f_out);
        fputs("charset=iso-8859-1\" />\n", 
            f_out);
        fprintf(f_out, "    <meta name=\"description\" content=\"%s\" />\n", 
            meta_desc);
        fprintf(f_out, "    <meta name=\"keywords\" content=\"%s\" />\n", 
            meta_key);
        fprintf(f_out, 
            "    <link href=\"%s\" rel=\"stylesheet\" type=\"text/css\" />\n",
            css_file);
        fprintf(f_out, "    <title>%s%s%s</title>\n", 
            title, subtitle_delim, subtitle);
        fputs("</head>\n\n\n", 
            f_out);
    
        /* Write body */
        
        fputs("<body>\n\n", 
            f_out);
        fputs("<a name=\"pagetop\"></a>\n", 
            f_out);
    
        /* Write menu , contents and footer */
        
        /*GenMainMenu(f_out, n);*/
        GenContents(f_out, n);
        GenFooter(f_out, footer);
        fputs("\n</body>\n\n</html>\n", 
            f_out);
        
        fclose(f_out);
    }
    return n;
}

int GenMainMenu(FILE *f_out, int Item)
{
    AL_CONST char   *maintitle, 
                    *mainurl;
    char            Str[10];
    int             n;
    
    fputs("\n<!--", f_out);
    fputs("    BEGIN - Code for the menu_contents_container starts here:    ", 
        f_out);
    fputs("-->\n\n", f_out);
    
    fputs("<div class=\"menu_content_container\">\n", f_out);
    
    fputs("\n<!--", f_out);
    fputs("    BEGIN - Code for the main menu starts here:    ", f_out);
    fputs("-->\n\n", f_out);
    
    fputs("<div class=\"mainmenu\">\n", f_out);
    fputs("    <ul class=\"main-list\">\n", f_out);    
            
    for(n = 0; n <= 49; n++) {
        snprintf(Str, 7, "item%d", Item);
        maintitle = get_config_string("mainmenu", Str, NULL);
        if(maintitle == NULL) break;
        
        snprintf(Str, 6, "url%d", Item);
        mainurl = get_config_string("mainmenu", Str, NULL);
        if(mainurl == NULL) break;
        
        fprintf(f_out, "        <li><a href=\"%s\">%s</a></li>\n", 
            mainurl, maintitle);
    
    }
    fputs("    </ul>\n", f_out);    
    
    fputs("</div>\n", f_out);
    fputs("\n<!--", f_out);
    fputs("    END - Code for the main menu ends here.    ", f_out);
    fputs("-->\n", f_out);
    return n;
}

int GenContents(FILE *f_out, int Item)
{
    AL_CONST char   *infile;
    char            Str[7], line[513];
    FILE            *f_in;
    int             n;
    
    snprintf(Str, 5, "in%d", Item);
    infile = get_config_string("contents", Str, NULL);
    if(infile == NULL) return 0;
    
    f_in = fopen(infile, "rt");
    if(f_in != NULL) {
        while(!feof(f_in)) {        
            if(fgets(line, 512, f_in) != NULL)
                fprintf(f_out, "%s", line);
        }         
    }
    
    fclose(f_in);

    fputs("</div>\n", f_out); /* end of contents */

    fputs("\n<!--", f_out);
    fputs("\tEND - Code for the contents ends here/\t", f_out);
    fputs("-->\n\n", f_out);
    
    fputs("<div class=\"content-spacer\"><br /></div>\n", f_out);

    fputs("\n<!--", f_out);
    fputs("\tEND - Code for the menu_content_container ends here:\t", f_out);
    fputs("-->\n\n", f_out);
    
    fputs("</div>\n", f_out); /* end of menu_content_container */
    
    return n;
}

int GenFooter(FILE *f_out, AL_CONST char *footer_file)
{

    FILE            *f_in;
    char            line[513];

    fputs("<div class=\"footer\">\n", f_out);
    fputs("    <p>\n", f_out);
    f_in = fopen(footer_file, "rt");
    if(f_in != NULL) {
        while(!feof(f_in)) {        
            if(fgets(line, 512, f_in) != NULL)
                fprintf(f_out, "%s", line);
        }         
    }
    fclose(f_in);
    fputs("    </p>\n", f_out);
    fputs("</div>\n", f_out);
    return 0;
}
