/*
    This file is part of Funiter,
    Real and complex function iteration software.

    misc.h - some misc. routines.

    Copyright (C) 1995-2007 Stijn Wolters.
    Original idea: Ernic Kamerich (University of Nijmegen).
    
    See README for contact information.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    See COPYING for more information.
*/

#ifndef _MISC
    #define MISC
    
    #include <stdio.h>
    #include <float.h>
    #include <allegro.h>
    
    /*
    **  These two defines are necessary to build Funiter with MingW, and
    **  probably other systems as well (except Linux and MS-DOS).
    */
    
    #ifndef M_PI
        #define M_PI                3.1415926535
    #endif
    
    #ifndef MAXLONG
        #define MAXLONG             (1 << 32)
    #endif

    /* Some other defines, the last one is to ensure precision in edit fields */

    #ifndef N_DBL_DIG
        #define N_DBL_DIG                     15
    #endif

    #ifndef MAXINT
        #define MAXINT                      65535
    #endif

    /* Not all compilers support min & max functions */
        
    double min(double a, double b);
    double max(double a, double b);
    
    /* Adapted from Allegro's config.c function 'get_config_float' */
    double get_config_double(AL_CONST char *section, AL_CONST char *name, 
        double def);
    /* Adapted from Allegro's config.c function 'get_config_float' */
    void set_config_double(AL_CONST char *section, AL_CONST char *name, 
        double val);
    
    int SimpleCopyTextFile(char *dest, char *src);

    int GetHighestStrLen(char *Str[], int First, int Last);

    /* Postscript defines */
    
    #define PORTRAIT                0
    #define LANDSCAPE               1
    
    /*
    **  WriteEPS
    **
    **  Write a bitmap to a Postscript file.
    **  EPS = Encapsulated PostScript
    **
    **  Bitmap      - Pointer to a bitmap.  
    **  w           - Bitmap width.
    **  h           - Bitmap height.
    **  fp          - FILE *, pointer naar bestandsinformatie.
    **  Mode        - int, 0 = portrait, 1 = landscape
    */
    
    int WriteEPS(BITMAP *Bitmap, int w, int h, FILE *fp, int Mode);
#endif
