/*
    This file is part of Funiter,
    Real and complex function iteration software.

    alconio.h - conio.h emulation for allegro GFX.

    Copyright (C) 1995-2007 Stijn Wolters.
    Original idea: Ernic Kamerich (University of Nijmegen).
    
    See README for contact information.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    See COPYING for more information.
*/

#ifndef _ALCONIO
    #define _ALCONIO
    
    /* Includes */
    
    #include <stdio.h>
    #include <stdarg.h>
    #include <string.h>
    #include <allegro.h>

    /*#include "keydefs.h"*/
                
    /* Position conversion routines */
        
    #define X_C2P(S,C)              ((C) << 3)
    #define X_P2C(S,P)              ((P) >> 3)

    #define Y_C2P(S,C)              ((C) * text_height(font) * (S)->Stretch)
    #define Y_P2C(S,P)              ((P) / (text_height(font) * (S)->Stretch))

    /* Color names */
        
    #define WHITE                   makecol(255, 255, 255)
    #define GRAY                    makecol(150, 150, 150)
    #define LIGHTGRAY               makecol(210, 210, 210)
    #define RED                     makecol(150, 0, 0)
    #define LIGHTRED                makecol(255, 0, 0)
    #define GREEN                   makecol(0, 150, 0)
    #define LIGHTGREEN              makecol(0, 210, 0)
    #define BLUE                    makecol(0, 0, 150)
    #define LIGHTBLUE               makecol(0, 0, 255)
    #define YELLOW                  makecol(252, 252, 84)
    #define CYAN                    makecol(84, 252, 252)
    #define BLACK                   makecol(0, 0, 0)

    /* Cursor modes */
        
    #define _NOCURSOR               0
    #define _SOLIDCURSOR            1
    #define _NORMALCURSOR           2
    
    typedef struct {
        int         XStart, YStart, Width, Height, FgCol, BkCol, 
                    CharWidth, CharHeight, CurX, CurY, Stretch,
                    CursorMode;
        BITMAP      *ScreenContents, *Cursor, *TextBuffer;
    
    } TConsole;
    
    TConsole *alconio_init(int CWidth, int CHeight, int CStretch, 
        int CFgCol, int CBkCol);

    /* Text output routines */
    
    int a_cprintf(TConsole *Console, const char *format, ...);
    int a_cputs(TConsole *Console, const char *s);
    int a_putch(TConsole *Console, char c);
    
    /* Text- and cursor manipulation routines */
    
    void a_clrscr(TConsole *Console);
    int a_gotoxy(TConsole *Console, int X, int Y);
    int a_wherex(TConsole *Console);
    int a_wherey(TConsole *Console);
    void _a_setcursortype(TConsole *Console, int mode);

    /* Colors and attributes */
       
    void a_textcolor(TConsole *Console, int Color);
    void a_textbackground(TConsole *Console, int Color);

    /* Keyboard functions */
    
    int a_getch(void);
    
    /* Functions to (re)store what's under the console-screen */
    
    int a_getimage(TConsole *Console, BITMAP *Image);
    int a_putimage(TConsole *Console, BITMAP *Image);
    
    void alconio_exit(TConsole *Console);
#endif
