/*
    This file is part of Funiter,
    Real and complex function iteration software.

    menutext.c - Funiter's default menu texts.
    
    Copyright (C) 1995-2010 Stijn Wolters.
    Original idea: Ernic Kamerich (University of Nijmegen).
    
    See README for contact information.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    See COPYING for more information.
*/

#include "menutext.h"

char               *MenuTitleStrings[] = {

        "MAIN - MENU:",
        "GRAPH - MENU:",
        "TYPE OF DIAGRAM - MENU:",
        "SELECT A SHAPE TO START WITH:",
        "FUNCTION - MENU:",
        "PARAMETER - MENU:",
        "SETTINGS - MENU:",
        "LAYOUT - MENU:",
        "COORDINATE - MENU:",
        "STEP-BY-STEP ITERATION - MENU:",
        "COLOR - MENU:",
        "FILE - MENU:"
},

                    *MiscTexts[] = {

        "ON ",
        "OFF",
        "FIXED",
        "FLOAT",
        "Read file:",
        "Save file:",

},

                    *FnHelpText[] = {
                    
        "Now you are able to define your own function:",
        "- Only the part which follows 'x ->' can be entered.",
        "- Variables (x,c) and function names are case insensitive.",
        "- For sin(), cos() and tan() arguments are in radians.",
        "add", "subtract", "multiply", "divide", "raise to power",
        "arcsine", "arctangent", "natural logarithm", "squareroot", 
        "absolute value", "where",
        "the largest integer value less or equal to x",
        
},

                    *CFnHelpText[] = {
        "Now you are able to define your own function:",
        "- Only the part which follows 'z ->' can be entered.",
        "- Variables (z,c) and function names are case insensitive.",
        "- For sin(), cos() and tan() arguments are in radians.",
},

                    *FnErrText[] = {
        
        "Error:",            
        "Syntax",
        "Out of range",
        "Division by zero",
        "Undefined symbol",
        "Unknown number format",
        "To many variables",
        "Missing ')'"
},

                    LicenseText[] = 

        "Please read this document carefully before using this software:\n"
        "\n"
        "Funiter V2.4.0 Copyright (C) 1995-2009 Stijn Wolters.\n"
        "Original idea: Ernic Kamerich (University of Nijmegen).\n"
        "\n"
        "See README for contact information.\n"
        "\n"
        "This program is free software; you can redistribute it and/or modify "
        "it under the terms of the GNU General Public License as published by "
        "the Free Software Foundation; either version 2 of the License, or "
        "(at your option) any later version.\n"
        "\n"
        "This program is distributed in the hope that it will be useful, "
        "but WITHOUT ANY WARRANTY; without even the implied warranty of "
        "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the "
        "GNU General Public License for more details.\n"
        "\n"
        "You should have received a copy of the GNU General Public License "
        "along with this program; if not, write to the Free Software "
        "Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 "  
        "USA"
        "\n"
        "See COPYING for more information.\n",

                    *EditColPalHelp[7] = {
        
        "Red",
        "Green",
        "Blue",
        "Cursor up down, left and right: select color",
        "<r>, <g> or <b>: Shift + Cursor Up: Increase red, green or blue "
        "component",
        "<r>, <g> or <b>: Shift + Cursor Down: Decrease red, green or blue "
        "component",
        "<Escape>: to previous menu" 
},
    
                    F1KeyStr[] = 
                    
        "[ F1 ] = Help.",

                    CalcHelpStr[] = 
        
        "Working: <Escape> aborts.",
    
                    *ZoomHelpStr[6] = {

        "ENTER    - Select area (zoom)    ",
        "ESCAPE   - Abort selection       ",
        "PGUP     - Smaller rect          ",
        "PGDN     - Larger rect           ",
        "0..9     - Skip n pixels (faster)",
        "ENTER    - Continue selection    "
},

                    *RealComplexStepHelpStr[4] = {

        "ENTER         - Iterate         ",
        "DELETE , <d>  - Erase screen    ",
        "R-button      - New selection   ",
        "ESCAPE        - To central menu "
},

                    *ComplexStepInvHelpStr[7] = {

        "<=>           - Both roots       ",
        "<+>           - Pos. root        ",
        "<->           - Neg. root        ",
        "ENTER         - Random root      ",
        "DELETE , <d>  - Erase screen     ",
        "R-button      - New selection    ",
        "Escape        - To central menu  "
    
},

                    *DefPointHelpStr[3] = {
    
        "ENTER          - Start selection",
        "Mouse position - Starting point ",
        "Escape         - To central menu",
    
},
    
                    *DefShapeHelpStr[4] = {  
        
        "ENTER      - Start selection   ",
        "L-button   - First/second point",
        "R-button   - New selection     ",
        "Escape     - To central menu   ",
    
},
    
                    *RealJumpStr[3] = {

        "Move mouse       - Change value      ",
        "ENTER / L-button - Select value      ",
        "ESCAPE           - To previous menu  "
},
        
                    *CplJumpHelpStr[6] = {
    
        "Move mouse - Change value      ",
        "L-button   - Julia             ",
        "R-button   - Inverse Julia     ",
        "<P>        - Preview Julia     ",
        "ENTER      - Select value      ",
        "ESCAPE     - To previous menu  "
},

                    *JuliaNoMemStr[] = {

        "Not enough memory to restore an image from "
        "the Julia-set, do you want to recalculate "
        "the Julia-set? "
        "Yes"
        "No"
};


TItem   MainItems[13] = {

    {   "Functiontype: from R to R  ", NULL, 0, 0, 0, 0, 1, 96   },
    {   "Graph                      ", NULL, 0, 0, 0, 0, 1, 97   },
    {   "Function                   ", NULL, 0, 0, 0, 0, 1, 97   },
    {   "Parameters                 ", NULL, 0, 0, 0, 0, 1, 97   },
    {   "Plot graph                 ", NULL, 0, 0, 0, 0, 1, 97   },
    {   " ",                           NULL, 0, 0, 0, 0, 1, 0    },
    {   "Settings                   ", NULL, 0, 0, 0, 0, 1, 97   },
    {   "Files                      ", NULL, 0, 0, 0, 0, 1, 97   },
    {   "Menustyle: Advanced        ", NULL, 0, 0, 0, 0, 1, 96   },
    {   "About Funiter              ", NULL, 0, 0, 0, 0, 1, 97   },
    {   "Quit program               ", NULL, 0, 0, 0, 0, 1, 96   },

    {   "Functiontype: from C to C  ", NULL, 0, 0, 0, 0, 1, 96   },
    {   "Menustyle: Standard        ", NULL, 0, 0, 0, 0, 1, 96   }

},
                    RealGraphItems[3] = {

    /* Real graphs */

    {   "Step-by-step iteration         ", NULL, 0, 0, 0, 0, 1, 97   },
    {   "Orbit diagram for variable x   ", NULL, 0, 0, 0, 0, 1, 96   },
    {   "Orbit diagram for variable c   ", NULL, 0, 0, 0, 0, 1, 96   }
},

                    ComplexGraphItems[5] = {

    /* Complex graphs */

    {   "Step-by-step iteration                     ", NULL, 0, 0, 0, 0, 1, 97  },
    {   "Step-by-step inverse iteration             ", NULL, 0, 0, 0, 0, 1, 97  },
    {   "Orbit diagram for variable z (Julia)       ", NULL, 0, 0, 0, 0, 1, 97  },
    {   "Orbit diagram for variable c (Mandelbrot)  ", NULL, 0, 0, 0, 0, 1, 97  },
    {   "Orbit diagram for variable c               ", NULL, 0, 0, 0, 0, 1, 97  }
},

                    RealDiagramItems[4] = {

    /* Real graphs */

    {   "Webdiagram                              ", NULL, 0, 0, 0, 0, 1, 96 },
    {   "Iteration values                        ", NULL, 0, 0, 0, 0, 1, 96 },
    {   "Stepdiagram                             ", NULL, 0, 0, 0, 0, 1, 96 },
    {   "Combination of webdiagram & stepdiagram ", NULL, 0, 0, 0, 0, 1, 96 }
},

                    ComplexStepShapeItems[4] = {

    /* Complex step-by-step shapes */

    {   "Point      ", NULL, 0, 0, 0, 0, 1, 97 },
    {   "Line       ", NULL, 0, 0, 0, 0, 1, 97 },
    {   "Rectangle  ", NULL, 0, 0, 0, 0, 1, 97 },
    {   "Circle     ", NULL, 0, 0, 0, 0, 1, 97 }
},

                    ComplexStepColorItems[3] = {
    
    /* Complex step-by-syep coloring method */
        
    {   "Color depends on starting point", NULL, 0, 0, 0, 0, 1, 96 },
    {   "Color depends on iter. steps   ", NULL, 0, 0, 0, 0, 1, 96 },
    {   "All iteration steps same color ", NULL, 0, 0, 0, 0, 1, 96 },
},

                    ComplexDiagramItems[4] = {

    /* Complex (orbit) diagrams */

    {   "Filled-in                  ", NULL, 0, 0, 0, 0, 1, 96 },
    {   "Escape time                ", NULL, 0, 0, 0, 0, 1, 96 },
    {   "Boundary trace             ", NULL, 0, 0, 0, 0, 1, 96 },
    {   "Inverse iteration method   ", NULL, 0, 0, 0, 0, 1, 0  }
},

                    RealFnItems[7] = {
    
    {   "x -> x\xB2 + c"                        , NULL, 0,  6, 0, 0, 1, 96 },
    {   "x -> frac(cx)"                         , NULL, 0,  8, 0, 0, 1, 96 },
    {   "x -> c * cos(x)"                       , NULL, 0, 10, 0, 0, 1, 96 },
    {   "x -> cx(1 - x)"                        , NULL, 0, 12, 0, 0, 1, 96 },
    {   "x -> -cx\xB3  + (c + 1) x\xB2 "        , NULL, 0, 14, 0, 0, 1, 96 },
    {   "x -> c(1 - |2x - 1|)"                  , NULL, 0, 16, 0, 0, 1, 96 },
    {   "User defined"                          , NULL, 0, 18, 0, 0, 1, 97 }
},

                    ComplexFnItems[4] = {

    {   "z -> z ^ 2 + c"                        , NULL, 0,  6, 0, 0, 1, 96 },
    {   "z -> z ^ 3 + c"                        , NULL, 0,  8, 0, 0, 1, 96 },
    {   "z -> z ^ 4 + c"                        , NULL, 0, 10, 0, 0, 1, 96 },
    {   "User defined"                          , NULL, 0, 12, 0, 0, 1, 97 }

},

                    UserDefFnItems[2] = {
    { "x ->", "                             ", 0, 0, 30, 30, 1, 32866 },
    { "z ->", "                             ", 0, 0, 30, 30, 1, 32866 }
},

                    ParameterItems[26] = {

    { "Value for parameter c            :", "            ", 
        0, 0, 12, 49, 1, 4194 
    },
    { "1st starting value for iteration :", "            ", 
        0, 0, 12, 49, 1, 4194 
    },
    { "2nd starting value for iteration :", "            ", 
        0, 0, 12, 49, 1, 4194 
    },
    { "Estimated lowest value           :", "            ", 
        0, 0, 12, 49, 1, 4194 
    },
    { "Estimated highest value          :", "            ", 
        0, 0, 12, 49, 1, 4194 
    },
    { "Y-coordinate (lowest)            :", "            ", 
        0, 0, 12, 49, 1, 4194 
    },
    { "Y-coordinate (highest)           :", "            ", 
        0, 0, 12, 49, 1, 4194 
    },
    { "Escape value                     :", "            ", 
        0, 0, 12, 49, 1, 4194 
    },
    { "Number of steps/iteration        :", "            ", 
        0, 0, 12, 49, 1, 2146 
    },
    { "Total number of iterations       :", "            ", 
        0, 0, 12, 49, 1, 2146 
    },
    { "Number of skipped iterationsteps :", "            ", 
        0, 0, 12, 49, 1, 2146 
    },

    /* Differences: Real: Step: index: 3, 4 and 9 */

    { "Lowest value for c               :", "            ", 
        0, 0, 12, 49, 1, 4194 
    },
    { "Highest value for c              :", "            ", 
        0, 0, 12, 49, 1, 4194 
    },
    { "Function N times iterated        :", "            ", 
        0, 0, 12, 49, 1, 2146 
    },

    /* Differences: Real: Orbits x: index: 3 and 4 */

    { "Lowest value for x               :", "            ", 
        0, 0, 12, 49, 1, 4194 
    },
    { "Highest value for x              :", "            ", 
        0, 0, 12, 49, 1, 4194 
    },

    /* Differences: Real: Orbits c: index: 3 and 4 */

    { "Lowest value for c               :", "            ", 
        0, 0, 12, 49, 1, 4194 
    },
    { "Highest value for c              :", "            ", 
        0, 0, 12, 49, 1, 4194 
    },

    /*
    **  Differences: Complex: Step: index: 1 and 2
    **               Complex: Orbits: index 1 and 2
    */

    { "Real part of c                   :", "            ", 
        0, 0, 12, 49, 1, 4194 
    },
    { "Imaginary part of c              :", "            ", 
        0, 0, 12, 49, 1, 4194 
    },

    /* Differences: Complex: Step: index: 3 to 6 */

    { "Min. for real part of values     :", "            ", 
        0, 0, 12, 49, 1, 4194 
    },
    { "Max. for real part of values     :", "            ", 
        0, 0, 12, 49, 1, 4194 
    },
    { "Min. for imaginary part of values:", "            ", 
        0, 0, 12, 49, 1, 4194 
    },
    { "Max. for imaginary part of values:", "            ", 
        0, 0, 12, 49, 1, 4194 
    },

    /* Differences: Complex: Orbits c: index 1 and 2 */

    { "Real part of z                   :", "            ", 
        0, 0, 12, 49, 1, 4194 
    },
    { "Imaginary part of z              :", "            ", 
        0, 0, 12, 49, 1, 4194 
    }

    },

                    SettingsItems[5] = {

    { "Screen layout                    ",  0, 0, 0, 0, 0, 1, 97 },
    { " ",                                  0, 0, 0, 0, 0, 1, 0  },
    { " ",                                  0, 0, 0, 0, 0, 1, 0  },
    { "Fixed / Floatingpoint           :",  0, 0, 0, 0, 0, 1, 0 },
    { "Parameter set connections       :",  0, 0, 0, 0, 0, 1, 96 }

},
                    LayoutItems[5] = {

    { "Coordinates             ", NULL, 0, 0, 0, 0, 1, 97 },
    { "Step-by-step iteration  ", NULL, 0, 0, 0, 0, 1, 97 },
    { "Colors                  ", NULL, 0, 0, 0, 0, 1, 97 },
    { " ",                        NULL, 0, 0, 0, 0, 1, 0  },
    { "Status line            :", NULL, 0, 0, 0, 0, 1, 96 }
},

                    CoordItems[3] = {

    { "Coordinate system         :", NULL, 0, 0, 0, 0, 1, 96 },
    { "Grid                      :", NULL, 0, 0, 0, 0, 1, 96 },
    { "Calibration               :", NULL, 0, 0, 0, 0, 1, 96 }
},

                    StepItems[4] = {

    { "Show coords at iter points :", NULL, 0, 0, 0, 0, 1, 0 },
    { "Text size                  :", "  ", 0, 0, 2, 2, 1, 0 },
    { "Connecting lines           :", NULL, 0, 0, 0, 0, 1, 96 },
    { "Line width                 :", "  ", 0, 0, 2, 2, 1, 2146 }
},

                    ColorItems[7] = {

    { "Grid                       :", "  ", 0, 0, 2, 2, 1, 96 },
    { "Graph of function          :", "  ", 0, 0, 2, 2, 1, 96 },
    { "Line x=y                   :", "  ", 0, 0, 2, 2, 1, 96 },
    { "1st starting value         :", "  ", 0, 0, 2, 2, 1, 96 },
    { "2nd starting value         :", "  ", 0, 0, 2, 2, 1, 96 },
    { " "                           , NULL, 0, 0, 2, 0, 1,    0 },
    { "Edit colorpalette           ", NULL, 0, 0, 0, 0, 1,   97 }
},

                    EditColPalItems[8] = {
                    
    { "Color :"               ,"   ", 0, 0, 3, 3, 1,  100 },
    { " "                     , NULL, 0, 0, 0, 0, 1,    0 },
    { "Red   :"               ,"   ", 0, 0, 3, 3, 1,  100 },
    { "Green :"               ,"   ", 0, 0, 3, 3, 1,  100 },
    { "Blue  :"               ,"   ", 0, 0, 3, 3, 1,  100 },
    { " "                     , NULL, 0, 0, 0, 0, 1,    0 },
    { "Invert black and white", NULL, 0, 0, 0, 0, 1,   96 },
    { "To settings menu      ", NULL, 0, 0, 0, 0, 1,   96 }
},
   
                    FilesItems[4] = {

    { "Load (.PAR)                ", NULL, 0, 0, 0, 0, 1, 97 },
    { "Load (.PRM , 2.1)          ", NULL, 0, 0, 0, 0, 1,  0 },
    { "Update configuration file  ", NULL, 0, 0, 0, 0, 1, 97 },
    { "Save (.PAR)                ", NULL, 0, 0, 0, 0, 1, 97 }
},


                    RJItems[8] = {

    /* Zoom is not for the combination 'web/step' */

    {   "ENTER    - Select area (zoom) ", NULL, 0, 0, 0, 0, 1, 96  },
    {   "<T>      - Change diagram type", NULL, 0, 0, 0, 0, 1, 96  },
    {   "Space    - Orbit diagram var.x", NULL, 0, 0, 0, 0, 1, 96  },
    {   "<S>      - Save menu          ", NULL, 0, 0, 0, 0, 1, 96  },
    {   "ESCAPE   - To parameter menu  ", NULL, 0, 0, 0, 0, 1, 96  },

    /* 1 & 2 are changed for 'orbit diagram var. x' */

    {   "Backspace- Step-by-step iter. ", NULL, 0, 0, 0, 0, 1, 96  },
    {   "Backspace- Orbit diagram var.x", NULL, 0, 0, 0, 0, 1, 96  },
    {   "Space    - Orbit diagram var.c", NULL, 0, 0, 0, 0, 1, 96  }
},

                    RJSItems[5] = {

        {   "<W>     - Webdiagram             ", NULL, 0, 0, 0, 0, 1, 96  },
        {   "<I>     - Iteration values       ", NULL, 0, 0, 0, 0, 1, 96  },
        {   "<S>     - Stepdiagram            ", NULL, 0, 0, 0, 0, 1, 96  },
        {   "<C>     - Combination: Web & Step", NULL, 0, 0, 0, 0, 1, 96  },
        {   "ESCAPE  - Previous menu          ", NULL, 0, 0, 0, 0, 1, 96  } 

    },
    
    CJItems[8] = {

        {   "ENTER    - Select area (zoom)     ", NULL, 0, 0, 0, 0, 1, 96  },
        {   "<T>      - Change diagram type    ", NULL, 0, 0, 0, 0, 1, 96  },
        {   "Backspace- Step-by-step iteration ", NULL, 0, 0, 0, 0, 1, 96  },
        {   "Space    - Mandelbrot set         ", NULL, 0, 0, 0, 0, 1, 96  },
        {   "<S>      - Save menu              ", NULL, 0, 0, 0, 0, 1, 96  },
        {   "ESCAPE   - To parameter menu      ", NULL, 0, 0, 0, 0, 1, 96  }, 

        {   "Space    - Julia set              ", NULL, 0, 0, 0, 0, 1, 96  },
        {   "Backspace- Julia set              ", NULL, 0, 0, 0, 0, 1, 96  }
    },

    CJSItems[3] = {
        
        {   "<1>    - Iteration         ", NULL, 0, 0, 0, 0, 1, 96 },
        {   "<2>    - Inverse iteration ", NULL, 0, 0, 0, 0, 1, 96 },
        {   "ESCAPE - Previous menu     ", NULL, 0, 0, 0, 0, 1, 96 }
    },
    
    CJSSItems[5] = {
    
        {   "<P>    - Point         ", NULL, 0, 0, 0, 0, 1, 96 },
        {   "<L>    - Line          ", NULL, 0, 0, 0, 0, 1, 96 },
        {   "<R>    - Rectangle     ", NULL, 0, 0, 0, 0, 1, 96 },
        {   "<C>    - Circle        ", NULL, 0, 0, 0, 0, 1, 96 },
        {   "ESCAPE - Previous menu ", NULL, 0, 0, 0, 0, 1, 96 }
    },
    
    CJSCItems[4] = {
    
        {   "<S>    - Color depends on starting point", NULL, 0, 0, 0, 0, 1, 96 },
        {   "<I>    - Color depends on iter. steps   ", NULL, 0, 0, 0, 0, 1, 96 },
        {   "<A>    - All iteration steps same color ", NULL, 0, 0, 0, 0, 1, 96 },
        {   "ESCAPE - To previous menu               ", NULL, 0, 0, 0, 0, 1, 96 }
    },
    
    CJOItems[7] = {
    
        {   "Julia:                             ", NULL, 0, 0, 0, 0, 1, 32 },
        {   "<F>    -  Filled-in                ", NULL, 0, 0, 0, 0, 1, 96 },
        {   "<E>    -  Escape time              ", NULL, 0, 0, 0, 0, 1, 96 },
        {   "<B>    -  Boundary trace           ", NULL, 0, 0, 0, 0, 1, 96 },
        {   "<I>    -  Inverse iteration method ", NULL, 0, 0, 0, 0, 1, 96 },
        {   "ESCAPE -  Previous menu            ", NULL, 0, 0, 0, 0, 1, 96 },

        {   "Mandelbrot:                        ", NULL, 0, 0, 0, 0, 1, 32 }
    
    },
       
    CSItems[5] = {

        {   "<P>    - Postscript (Portrait) ", NULL, 0, 0, 0, 0, 1, 96  },
        {   "<L>    - Postscript (Landscape)", NULL, 0, 0, 0, 0, 1, 96  },
        {   "<X>    - PC Paintbrush PCX     ", NULL, 0, 0, 0, 0, 1, 96  },
        {   "<J>    - JPEG (.JPG)           ", NULL, 0, 0, 0, 0, 1, 96  },
        {   "ESCAPE - To previous menu      ", NULL, 0, 0, 0, 0, 1, 96  }

    };
