/*
 * LILACA (LILACA is Langton's Ant Cellular Automaton)
 * by Adam "akaz" Kazimierczak
 *
 * version: 0.9 beta
 * date: January 2010
 *
 * visit: http://akaz.com.pl/
 * or
 * mail me by: adam.kazimierczak@gmail.com
 *
 * License: GNU GPLv3
 */

/*
 *   This file is part of LILACA.
 *
 *   LILACA is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   LILACA is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with LILACA.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <allegro.h>

#ifndef _LANGTON_H
#define	_LANGTON_H

#define VERSION "0.9 beta"

namespace Langton {
    class Field {
    private:
        void draw_dots(BITMAP *buffer);
        void set_fill(bool fill, unsigned &pos_x, unsigned &pos_y);
        void set_black(unsigned int &x, unsigned int &y);
        void set_white(unsigned int &x, unsigned int &y);
    public:
        bool cell[800][800];
        unsigned int filled_cells;

        void reset();
        void update(BITMAP *buffer, unsigned int &pos_x, unsigned int &pos_y);
        void create_random_dots();
    };


    class Ant{
    private:
        void move();
        void draw(BITMAP *buffer);
        void turn_left();
        void turn_right();
        void check_field(bool cell[800][800]);
    public:
        unsigned int pos_x, pos_y;
        unsigned char direction; // ( N, E, S, W ) uppercase

        void update(BITMAP *buffer, bool cell[800][800]);
        void set_position(unsigned int x, unsigned int y);
        void set_direction(char dir);
    };


    class Info {
    private:
        void draw_info(BITMAP *buffer, Field &field, Ant &ant);
        unsigned int step;
    public:
        void update(BITMAP *buffer, Field &field, Ant &ant);        
    };


    class System {
    private:
        void init();
        void deinit();
    public:
        BITMAP *buffer;

        Field field;
        Ant ant;
        Info info;

        void start();
        
    };
};


#endif	/* _LANGTON_H */

