#include "titlescr.h"
#include <allegro.h>
#include "common.h"
#include "thegame.h"
#include "smoothie.h"
#include "sounds.h"
#include "fth.h"
#include "hom.h"

int fx1i = 0;
int fx2i = 0;
int menupage = 0;
int menusel = 0;
int interrupted = 0;
int curtrivia = 0;
int maxtrivia = 0;

const char *trivia1[] = {
	"THIS GAME WAS INSPIRED BY DESERT BUS",
	"",
	"A VIDEO GAME BY PENN AND TELLER",
	NULL
};

const char *trivia2[] = {
	"ONE OF THE FIRST RANDOMIZED DOUBLEBLIND TESTS",
	"WAS CONDUCTED IN 1835 JUST FOR THE SAKE OF TESTING",
	"THE CLAIMS OF HOMEOPATHY",
	"",
	"HOMEOPATHY FAILED TO PROVE EFFICACY BEYOND PLACEBO",
	NULL
};

const char *trivia3[] = {
	"POST HOC ERGO PROPTER HOC IS A LOGICAL FALLACY",
	"IN WHICH A LATER EVENT IS SAID TO BE CAUSED BY",
	"AN EARLIER EVENT SIMPLY BECAUSE THE EARLIER",
	"EVENT TOOK PLACE",
	NULL
};

const char *trivia4[] = {
	"APPEAL TO NATURE IS A LOGICAL FALLACY IN WHICH",
	"SOMETHING THAT COMES FROM THE NATURE IS",
	"CONSIDERED GOOD AND SAFE BY DEFAULT OR UNNATURAL",
	"THINGS ARE CONSIDERED BAD BY DEFAULT",
	"",	
	"ANTIBIOTICS BAD",
	"POISONOUS MUSHROOMS GOOD",
	NULL
};

const char *trivia5[] = {
	"ACCORDING TO A 2002 SURVEY BY THE NATIONAL CENTER",
	"FOR HEALTH STATISTICS AND THE NATIONAL CENTER FOR",
	"COMPLEMENTARY AND ALTERNATIVE MEDICINE",
	"APPROX 75 PERCENT OF ADULTS IN THE UNITED STATES",
	"HAD USED SOME FORM OF ALTERNATIVE MEDICINE",
	"",
	"THE MAJORITY OF THAT WAS PRAYER",
	NULL
};

const char *trivia6[] = {
	"INSTEAD OF HAVING AN OPEN DISCUSSION OF PEER",
	"REVIEWED MEDICAL LITERATURE OR A PUBLIC DEBATE",
	"IN MAINSTREAM MEDIA THE BRITISH CHIROPRACTIC",
	"ASSOCIATION FILED A LAWSUIT IN 2009 AGAINST",
	"A DOCTOR WHO WROTE AN ARTICLE SAYING THAT",
	"CHIROPRACTICE IS BOGUS",
	"",
	"BECAUSE OBVIOUSLY THAT IS HOW ONE DEFENDS",
	"AGAINST SUSPICIONS OF EFFICACY",
	NULL
};

const char *trivia7[] = {
	"THE FAITH HEALING PART OF THIS GAME IS",
	"INHERENTLY IMPOSSIBLE TO BEAT",
	"",
	"AS ONE WOULD EXPECT",
	NULL
};

const char *trivia8[] = {
	"THE AFTERMATH SCREEN WILL ALWAYS DISPLAY",
	"ZEROES FOR EVERYTHING",
	"",
	"AS ONE WOULD EXPECT",
	NULL
};

const char *trivia9[] = {
	"THERE ARE FAMILIES ALL AROUND THE WORLD WHO",
	"HAVE CHOSEN TO RELY COMPLETELY ON ALTERNATIVE",
	"MEDICINE INSTEAD OF SEEKING PROPER MEDICAL CARE",
	"",
	"THE RESULTS HAVE BEEN REGRETTABLE",
	NULL
};

const char *trivia10[] = {
	"THE JAMES RANDI EDUCATIONAL FOUNDATION HAS",
	"BEEN RUNNING A ONE MILLION DOLLAR CHALLENGE",
	"FOR PROOF OF THE PARANORMAL",
	"",
	"HOMEOPATHY AMONG OTHER THINGS IS APPLICABLE",
	"",
	"THE CHALLENGE HAS BEEN RUNNING FROM 1964",
	"AND IN 2009 THE PRIZE IS YET TO BE CLAIMED",
	NULL
};

const char *trivia11[] = {
	"ALTERNATIVE MEDICINE IS AN ANAGRAM OF",
	"",
	"RECTAL ENEMA I INVITED",
	"",
	"IT RECEIVED AN AILMENT",
	NULL
};

const char *trivia12[] = {
	"THE CLOCK IN THE FAITH HEALING PART OF THIS",
	"GAME IS OFF FROM THE AUDIBLE CLOCK BEAT",
	"",
	"THIS IS DONE ON PURPOSE TO ANNOY PLAYERS",
	NULL
};

void alglehliaegil(void)
{
	fx1i = 270;
}

void initTitlescreen(void)
{
	fx1i = 0;	
	fx2i = prevProcGame != NULL ? 350 : 0;
	menupage = 0;
	menusel = 0;
	setPalState(6);
	setSndState(6);
	butnaps[0] = smoothie(7);
	butnaps[1] = smoothie(8);
	butnaps[2] = smoothie(9);
	butnaps[3] = smoothie(10);
	butnaps[4] = smoothie(12);
	maxtrivia = 11;
}

void procTitlescreen(void)
{	
	BITMAP *butnapier;
	const char **triv = NULL;
	int fs;
	int y;
	int mm = 0;
	y = 120;
	if (fx2i > 200)
	{
		y -= (fx2i - 200) / 2;
	}
	draw_sprite(buffa, butnaps[0], 160 - butnaps[0]->w, y - (butnaps[0]->h / 2));
	draw_sprite(buffa, butnaps[1], 160, y - (butnaps[0]->h / 2));
	if (fx1i > 50)
	{		
		if (fx1i < 160)
		{
			butnapier = butnaps[3];
		}
		else
		{
			butnapier = butnaps[2];
		}
		draw_sprite(buffa, butnapier, fx1i - (butnapier->w / 2), (y - 1) - (butnapier->h / 2) + (butnaps[0]->h / 2));
	}
	if (fx2i == 350)
	{
		fs = text_height(lfont) / 2;
		switch (menupage)
		{
			case 0:
				mm = 2;
				textprintf_centre_ex(buffa, lfont, 160, 121 - fs, 3, -1, "NEW GAME");
				textprintf_centre_ex(buffa, lfont, 160, 120 - fs, 1, -1, "NEW GAME");
				textprintf_centre_ex(buffa, lfont, 160, 136 - fs, 3, -1, "BONUS CONTENT");
				textprintf_centre_ex(buffa, lfont, 160, 135 - fs, (achemastercount >= 10) ? 1 : 3, -1, "BONUS CONTENT");
				textprintf_centre_ex(buffa, lfont, 160, 151 - fs, 3, -1, "EXIT");
				textprintf_centre_ex(buffa, lfont, 160, 150 - fs, 1, -1, "EXIT");
				if (nextProcGame == procTitlescreen)
				{
					draw_sprite(buffa, butnaps[4], 90 - (butnaps[4]->w / 2), 120 + (15 * menusel) - (butnaps[4]->h / 2));
					draw_sprite(buffa, butnaps[4], 230 - (butnaps[4]->w / 2), 120 + (15 * menusel) - (butnaps[4]->h / 2));
				}
				break;
			case 1:
				mm = 2;
				textprintf_centre_ex(buffa, lfont, 160, 121 - fs, 3, -1, "HOMEOPATHY");
				textprintf_centre_ex(buffa, lfont, 160, 120 - fs, 1, -1, "HOMEOPATHY");		
				textprintf_centre_ex(buffa, lfont, 160, 136 - fs, 3, -1, "FAITH HEALING");
				textprintf_centre_ex(buffa, lfont, 160, 135 - fs, 1, -1, "FAITH HEALING");
				textprintf_centre_ex(buffa, lfont, 160, 151 - fs, 3, -1, "BACK");
				textprintf_centre_ex(buffa, lfont, 160, 150 - fs, 1, -1, "BACK");
				if (nextProcGame == procTitlescreen)
				{
					draw_sprite(buffa, butnaps[4], 90 - (butnaps[4]->w / 2), 120 + (15 * menusel) - (butnaps[4]->h / 2));
					draw_sprite(buffa, butnaps[4], 230 - (butnaps[4]->w / 2), 120 + (15 * menusel) - (butnaps[4]->h / 2));
				}
				break;
			case 2:
				mm = 4;				
				textprintf_ex(buffa, lfont, 60, 121 - fs, 3, -1, "FAST FAITH HEALING");
				textprintf_ex(buffa, lfont, 60, 120 - fs, (achemastercount >= 10) ? 1 : 3, -1, "FAST FAITH HEALING");
				textprintf_right_ex(buffa, lfont, 260, 121 - fs, 3, -1, fastheal ? "ON" : "OFF");
				textprintf_right_ex(buffa, lfont, 260, 120 - fs, (achemastercount >= 10) ? 2 : 3, -1, fastheal ? "ON" : "OFF");
				textprintf_ex(buffa, lfont, 60, 136 - fs, 3, -1, "FAST SUCCUSSION");
				textprintf_ex(buffa, lfont, 60, 135 - fs, (achemastercount >= 14) ? 1 : 3, -1, "FAST SUCCUSSION");
				textprintf_right_ex(buffa, lfont, 260, 136 - fs, 3, -1, fastsuccuss ? "ON" : "OFF");
				textprintf_right_ex(buffa, lfont, 260, 135 - fs, (achemastercount >= 14) ? 2 : 3, -1, fastsuccuss ? "ON" : "OFF");
				textprintf_ex(buffa, lfont, 60, 151 - fs, 3, -1, "INVERTED PALETTE");
				textprintf_ex(buffa, lfont, 60, 150 - fs, (achemastercount >= 18) ? 1 : 3, -1, "INVERTED PALETTE");
				textprintf_right_ex(buffa, lfont, 260, 151 - fs, 3, -1, invertpalette ? "ON" : "OFF");
				textprintf_right_ex(buffa, lfont, 260, 150 - fs, (achemastercount >= 18) ? 2 : 3, -1, invertpalette ? "ON" : "OFF");
				textprintf_centre_ex(buffa, lfont, 160, 166 - fs, 3, -1, "TRIVIA");
				textprintf_centre_ex(buffa, lfont, 160, 165 - fs, (achemastercount >= 22) ? 1 : 3, -1, "TRIVIA");
				textprintf_centre_ex(buffa, lfont, 160, 181 - fs, 3, -1, "BACK");
				textprintf_centre_ex(buffa, lfont, 160, 180 - fs, 1, -1, "BACK");
				if (nextProcGame == procTitlescreen)
				{
					draw_sprite(buffa, butnaps[4], 48 - (butnaps[4]->w / 2), 120 + (15 * menusel) - (butnaps[4]->h / 2));
					draw_sprite(buffa, butnaps[4], 272 - (butnaps[4]->w / 2), 120 + (15 * menusel) - (butnaps[4]->h / 2));
				}
				break;
			case 3:
				mm = 0;
				textprintf_centre_ex(buffa, sfont, 160, 91, 3, -1, "TRIVIA %02d OF %02d", curtrivia + 1, maxtrivia + 1);
				textprintf_centre_ex(buffa, sfont, 160, 90, 1, -1, "TRIVIA %02d OF %02d", curtrivia + 1, maxtrivia + 1);
				switch (curtrivia)
				{
					case 0:
						triv = trivia1;
						break;
					case 1:
						triv = trivia2;
						break;
					case 2:
						triv = trivia3;
						break;
					case 3:
						triv = trivia4;
						break;
					case 4:
						triv = trivia5;
						break;
					case 5:
						triv = trivia6;
						break;
					case 6:
						triv = trivia7;
						break;
					case 7:
						triv = trivia8;
						break;
					case 8:
						triv = trivia9;
						break;
					case 9:
						triv = trivia10;
						break;
					case 10:
						triv = trivia11;
						break;
					case 11:
						triv = trivia12;
						break;
				}
				if (triv != NULL)
				{
					y = 110;
					while (*triv)
					{
						textprintf_centre_ex(buffa, sfont, 160, y, 2, -1, *triv);
						y += text_height(sfont) + 2;
						triv++;
					}
				}
				textprintf_centre_ex(buffa, sfont, 160, 183, 3, -1, "PRESS LEFT OR RIGHT TO CHANGE ITEM");
				textprintf_centre_ex(buffa, sfont, 160, 182, 1, -1, "PRESS LEFT OR RIGHT TO CHANGE ITEM");
				textprintf_centre_ex(buffa, lfont, 160, 201 - fs, 3, -1, "BACK");
				textprintf_centre_ex(buffa, lfont, 160, 200 - fs, 1, -1, "BACK");
				if (nextProcGame == procTitlescreen)
				{
					draw_sprite(buffa, butnaps[4], 130 - (butnaps[4]->w / 2), 200 - (butnaps[4]->h / 2));
					draw_sprite(buffa, butnaps[4], 190 - (butnaps[4]->w / 2), 200 - (butnaps[4]->h / 2));
				}
		}
		textprintf_centre_ex(buffa, sfont, 160, 227, 3, -1, "ENTRY TO SPEEDHACK 2009 BY INPHERNIC");
		textprintf_centre_ex(buffa, sfont, 160, 226, 1, -1, "ENTRY TO SPEEDHACK 2009 BY INPHERNIC");
	}
	if (transitionfinished == 1)
	{
		if (!achievements[0])
		{
			newachievements[0] = 1;
		}
		loadTrack(11);
		asdf(alglehliaegil);
		startTrack();
		transitionfinished = 0;
	}
	if (timerblink != 0)
	{
		if (fx2i < 350)
		{
			fx2i++;
		}
		if (fx1i > 0)
		{
			fx1i-=5;
		}
		if (acceptinput)
		{
			if (key[KEY_ESC])
			{
				if (fx2i < 350)
				{
					fx2i = 350;
					clear_keybuf();
					key[KEY_UP] = 0;
					key[KEY_DOWN] = 0;
					key[KEY_ENTER] = 0;
					key[KEY_SPACE] = 0;
					key[KEY_ESC] = 0;
					interrupted = 1;
				}
				else
				{
					nextProcGame = NULL;
				}
			}
			else
			{
				if (fx2i < 350)
				{
					if (keypressed())
					{
						fx2i = 350;
						clear_keybuf();
						key[KEY_UP] = 0;
						key[KEY_DOWN] = 0;
						key[KEY_ENTER] = 0;
						key[KEY_SPACE] = 0;
						interrupted = 1;
					}			
				}
				else
				{
					if (key[KEY_UP])
					{
						playSound(0);
						menusel--;
						if (menusel < 0) {
							menusel = mm;
						}
						key[KEY_UP] = 0;
						if (!achievements[3])
						{
							newachievements[3] = 1;
						}
					}
					if (key[KEY_DOWN])
					{
						playSound(0);
						menusel++;
						key[KEY_DOWN] = 0;
						if (menusel > mm) {
							menusel = 0;
						}
						if (!achievements[3])
						{
							newachievements[3] = 1;
						}						
					}
					if (key[KEY_LEFT])
					{
						if (menupage == 3)
						{
							playSound(0);
							curtrivia--;
							if (curtrivia < 0)
							{
								curtrivia = maxtrivia;
							}
						}
						key[KEY_LEFT] = 0;
					}
					if (key[KEY_RIGHT])
					{
						if (menupage == 3)
						{
							playSound(0);
							curtrivia++;
							if (curtrivia > maxtrivia)
							{
								curtrivia = 0;
							}
						}
						key[KEY_RIGHT] = 0;
					}		
					if (key[KEY_A])
					{
						playSound(4);
						key[KEY_A] = 0;
					}
					if (key[KEY_ENTER] || key[KEY_SPACE])
					{
						playSound(1);
						if (!achievements[3])
						{
							newachievements[3] = 1;
						}						
						switch (menupage)
						{
							case 0:
								switch (menusel)
								{
									case 0:
										menupage = 1;
										menusel = 2;
										break;
									case 1:
										if (achemastercount >= 10)
										{
											menupage = 2;
											menusel = 4;
										}
										else
										{
											if (!achievements[5])
											{
												newachievements[5] = 1;
											}
										}
										break;
									case 2:
										nextProcGame = NULL;
										break;
								}
								break;
							case 1:
								switch (menusel)
								{
									case 0:
										if (!achievements[6])
										{
											newachievements[6] = 1;
										}
										goToHomeopathy();
										break;
									case 1:
										if (!achievements[6])
										{
											newachievements[6] = 1;
										}
										goToFaithHealing();
										break;
									case 2:
										menupage = 0;
										menusel = 0;
										break;
								}
								break;
							case 2:
								switch (menusel)
								{
									case 0:
										if (achemastercount >= 10)
										{
											fastheal = fastheal ? 0 : 1;
										}
										break;
									case 1:
										if (achemastercount >= 14)
										{
											fastsuccuss = fastsuccuss ? 0 : 1;
										}
										break;
									case 2:
										if (achemastercount >= 18)
										{
											invertpalette = invertpalette ? 0 : 1;
											setPalState(palstate);
										}
										break;
									case 3:
										if (achemastercount >= 22)
										{
											curtrivia = 0;
											menupage = 3;
											menusel = 0;
										}
										break;
									case 4:
										menupage = 0;
										menusel = 1;
										break;
								}
								break;
							case 3:
								switch (menusel)
								{
									case 0:
										menupage = 2;
										menusel = 3;
										break;
								}
								break;
						}
						key[KEY_ENTER] = 0;
						key[KEY_SPACE] = 0;
					}
				}
			}
		}
		if (fx2i >= 350)
		{
			if (interrupted == 0 && !achievements[4])
			{
				newachievements[4] = 1;
			}		
		}		
	}
}

void goToTitlescreen(void)
{
	procInit = initTitlescreen;
	nextProcGame = procTitlescreen;	
}
