#include "thegame.h"
#include <allegro.h>
#include <stdio.h>
#include "common.h"
#include "titlescr.h"
#include "sounds.h"
#include "smoothie.h"
#include "parts.h"
#include "fth.h"
#include "hom.h"

BITMAP *butnaps[30];
int running = 1;
int transi = 0;
int acceptinput = 0;
volatile int transitionfinished = 0;
int newachievements[30];
int achievements[30];
int achecounter = 0;
int dispfps = 0;
int achemastercount = 0;
int bonuslocked = 1;
volatile int timan60 = 0;
int timerblink = 0;
BITMAP *buffa = NULL;
BITMAP *wshadow = NULL;
BITMAP *obs = NULL;
BITMAP *prg0 = NULL;
BITMAP *prg1 = NULL;
BITMAP *shade = NULL;
FONT *sfont = NULL;
FONT *lfont = NULL;
void (*procInit)(void) = NULL;
void (*procGame)(void) = NULL;
void (*nextProcGame)(void) = NULL;
void (*prevProcGame)(void) = NULL;
int fastheal = 0;
int fastsuccuss = 0;
int invertpalette = 0;
volatile int tcx = 0;
volatile int cfps = 0;
volatile int tfps = 0;

const char *achedesc[] = {
	"LAUNCHED THE GAME",
	"QUIT THE GAME",
	"PRESSED A BUTTON",
	"FIGURED OUT THE MENU SYSTEM",
	"DID NOT INTERRUPT THE TITLE SEQUENCE",
	"WAS CLEVER WITH THE BONUS CONTENT MENU ITEM",
	"STARTED A NEW GAME",
	"UNLOCKED BONUS CONTENT WITH 10 ACHIEVEMENTS",
	"FOLLOWED INSTRUCTIONS",
	"DID FAITH HEALING FOR ONE MINUTE",
	"DID FAITH HEALING FOR ONE HOUR",
	"DID FAITH HEALING FOR ONE DAY",
	"DID FAITH HEALING FOR ONE YEAR",
	"DID FAITH HEALING FOR 1000 YEARS",
	"COMPLETED 10 C POTENCY",
	"COMPLETED 20 C POTENCY",
	"COMPLETED 50 C POTENCY",
	"COMPLETED 100 C POTENCY",
	"COMPLETED 200 C POTENCY",
	"COMPLETED 500 C POTENCY",
	"COMPLETED 999 C POTENCY",
	"UNLOCKED BONUS CONTENT WITH 14 ACHIEVEMENTS",
	"UNLOCKED BONUS CONTENT WITH 18 ACHIEVEMENTS",
	"UNLOCKED BONUS CONTENT WITH 22 ACHIEVEMENTS",
};

void drawWindow(int x1, int y1, int x2, int y2, int c, int huom1, int huom2)
{
	rectfill(buffa, x1, y1, x2, y2, 4);
	if (huom1)
	{
		draw_sprite(buffa, obs, x1 + 2, ((y1 + y2) / 2) - (obs->h / 2));
	}
	if (huom2)
	{
		draw_sprite(buffa, obs, (x2 - 1) - obs->w, ((y1 + y2) / 2) - (obs->h / 2));
	}
	x1--; y1--; x2++; y2++;
	rect(buffa, x1, y1, x2, y2, 3);
	y2++;
	drawing_mode(DRAW_MODE_MASKED_PATTERN, wshadow, x2, y2); 
	rectfill(buffa, x1, y2, x2, y2 + (wshadow->h - 1), c);
	drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);
}

void drawShade(int c)
{
	drawing_mode(DRAW_MODE_MASKED_PATTERN, shade, 0, 0); 
	rectfill(buffa, 0, 0, 320, 240, c);
	drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);
}

void displaytime(int x, int y, int *yrs, int *days, int *hrs, int *mins, int *secs)
{
	int hc = 99;
	int act;
	if (yrs != NULL)
	{
		act = 0;
		if (*yrs > 0)
		{
			hc = 1;
			act = 1;
		}		
		textprintf_ex(buffa, lfont, x, y, 3, -1, "000");
		x += text_length(lfont, "000");
		textprintf_right_ex(buffa, lfont, x, y, act ? 2 : 3, 4, "%d", *yrs);
		textprintf_ex(buffa, sfont, x, y + text_height(lfont) - text_height(sfont), act ? 2 : 3, -1, "Y");
		x += text_length(sfont, "Y");
	}
	if (days != NULL)
	{
		act = 0;
		if (*days > 0 && hc > 2)
		{
			hc = 2;
		}
		if (*days > 0 || hc < 2)
		{
			act = 1;
		}
		textprintf_ex(buffa, lfont, x, y, hc < 2 ? 2 : 3, -1, "000");
		x += text_length(lfont, "000");
		textprintf_right_ex(buffa, lfont, x, y, act ? 2 : 3, 4, "%d", *days);
		textprintf_ex(buffa, sfont, x, y + text_height(lfont) - text_height(sfont), act ? 2 : 3, -1, "D");
		x += text_length(sfont, "D");
	}
	if (hrs != NULL)
	{
		act = 0;
		if (*hrs > 0 && hc > 3)
		{
			hc = 3;
		}
		if (*hrs > 0 || hc < 3)
		{
			act = 1;
		}
		textprintf_ex(buffa, lfont, x, y, hc < 3 ? 2 : 3, -1, "00");
		x += text_length(lfont, "00");
		textprintf_right_ex(buffa, lfont, x, y, act ? 2 : 3, 4, "%d", *hrs);
		textprintf_ex(buffa, sfont, x, y + text_height(lfont) - text_height(sfont), act ? 2 : 3, -1, "H");
		x += text_length(sfont, "H");
	}
	if (mins != NULL)
	{
		act = 0;
		if (*mins > 0 && hc > 4)
		{
			hc = 4;
		}
		if (*mins > 0 || hc < 4)
		{
			act = 1;
		}
		textprintf_ex(buffa, lfont, x, y, hc < 4 ? 2 : 3, -1, "00");
		x += text_length(lfont, "00");
		textprintf_right_ex(buffa, lfont, x, y, act ? 2 : 3, 4, "%d", *mins);
		textprintf_ex(buffa, sfont, x, y + text_height(lfont) - text_height(sfont), act ? 2 : 3, -1, "M");
		x += text_length(sfont, "M");
	}
	if (secs != NULL)
	{		
		act = 1;
		if (*secs > 0 && hc > 5)
		{
			hc = 5;
		}
		textprintf_ex(buffa, lfont, x, y, hc < 5 ? 2 : 3, -1, "00");
		x += text_length(lfont, "00");
		textprintf_right_ex(buffa, lfont, x, y, act ? 2 : 3, 4, "%d", *secs);
		textprintf_ex(buffa, sfont, x, y + text_height(lfont) - text_height(sfont), act ? 2 : 3, -1, "S");
		x += text_length(sfont, "S");
	}
}

void drawBar(int x1, int x2, int y, int min, int max, int v)
{
	int pos;
	rect(buffa, x1, y, x2, y + 11, 2);
	putpixel(buffa, x1, y, 3);
	putpixel(buffa, x2, y, 3);
	putpixel(buffa, x1, y + 11, 3);
	putpixel(buffa, x2, y + 11, 3);	
	x1++;
	x2--;
	y++;
	drawing_mode(DRAW_MODE_COPY_PATTERN, prg0, x1, y); 
	rectfill(buffa, x1, y, x2, y + 9, 2);
	if (v > min)
	{
		pos = x1 + ((float)(x2 - x1) * ((float)v - (float)min) / ((float)max - (float)min));
		if (x1 + pos > x2)
		{
			pos = x2 - x1;
		}
		drawing_mode(DRAW_MODE_COPY_PATTERN, prg1, x1, y);
		rectfill(buffa, x1, y, x1 + pos, y + 9, 2);
	}
	drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);
}

void instaquit(void)
{
	nextProcGame = NULL;
}

void timan60proc(void)
{
	timan60++;
	tcx++;
	if (tcx >= 60)
	{
		tcx -= 60;
		cfps = tfps;
		tfps = 0;
	}
}

void drawBasicGameplay(void)
{
	rectfill(buffa, 0, 26, 320, 214, 2);
	rectfill(buffa, 0, 0, 320, 23, 4);
	line(buffa, 0, 24, 320, 24, 3);
	rectfill(buffa, 0, 216, 320, 240, 4);
	line(buffa, 0, 215, 320, 215, 3);
	drawing_mode(DRAW_MODE_MASKED_PATTERN, wshadow, 0, 25); 
	rectfill(buffa, 0, 25, 320, 25 + (wshadow->h - 1), 1);
	drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);
}

int loadResources(void)
{
	BITMAP *bnp;
	bnp = smoothie(0);
	if (bnp == NULL)
	{
		allegro_message("Could not make smoothie with flavour 0");
		return 0;
	}
	sfont = grab_font_from_bitmap(bnp);
	destroy_bitmap(bnp);
	if (sfont == NULL)
	{
		allegro_message("Smoothie with flavour 0 tastes bad");
		return 0;
	}
	bnp = smoothie(1);
	if (bnp == NULL)
	{
		allegro_message("Could not make smoothie with flavour 1");
		return 0;
	}
	lfont = grab_font_from_bitmap(bnp);
	destroy_bitmap(bnp);
	if (sfont == NULL)
	{
		allegro_message("Smoothie with flavour 1 tastes bad");
		return 0;
	}
	wshadow = smoothie(13);
	if (wshadow == NULL)
	{
		allegro_message("Smoothie with flavour 13 tastes bad");
		return 0;
	}
	obs = smoothie(14);
	if (obs == NULL)
	{
		allegro_message("Smoothie with flavour 14 tastes bad");
		return 0;
	}
	prg0 = smoothie(18);
	if (obs == NULL)
	{
		allegro_message("Smoothie with flavour 18 tastes bad");
		return 0;
	}
	prg1 = smoothie(19);
	if (obs == NULL)
	{
		allegro_message("Smoothie with flavour 19 tastes bad");
		return 0;
	}
	shade = smoothie(20);
	if (shade == NULL)
	{
		allegro_message("Smoothie with flavour 20 tastes bad");
		return 0;
	}
	return 1;
}

int initTheGame(void)
{
	int deskydesk;
	if (allegro_init() != 0)
	{
		allegro_message("Could not init Allegro");
		return 0;
	}
	if (install_keyboard() != 0)
	{
		allegro_message("Could not init keyboard");
		return 0;
	}	
	deskydesk = desktop_color_depth();
	if (deskydesk == 0)
	{
		deskydesk = 16;
	}
	deskydesk = 8;
	set_color_depth(deskydesk);
	//set_color_conversion(COLORCONV_NONE);
	if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0) != 0)
	{
		allegro_message("Could not set graphics mode");
		return 0;
	}
	set_window_title("Alternative Medicine");
	buffa = create_bitmap(320, 240);
	if (buffa == NULL)
	{
		allegro_message("Could not create double buffer");
		return 0;
	}
	if (install_timer() != 0)
	{
		allegro_message("Could not init timers");
		return 0;
	}
	if (install_int_ex(timan60proc, BPS_TO_TIMER(60)) != 0)
	{
		allegro_message("Could not init timer");
		return 0;
	}
	if (install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL) != 0)
	{
		allegro_message("Could not init sound");
		return 0;
	}
	if (loadResources() == 0)
	{
		allegro_message("Could not load resources");
		return 0;
	}
	initParts();
	initSound();
	set_display_switch_mode(SWITCH_BACKGROUND);
	set_close_button_callback(instaquit);
	return 1;
}

void uninitTheGame(void)
{
	uninitSound();
	uninitParts();
	unloadTrack();
	if (wshadow != NULL)
	{
		destroy_bitmap(wshadow);
		wshadow = NULL;
	}
	if (shade != NULL)
	{
		destroy_bitmap(shade);
		shade = NULL;
	}
	if (obs != NULL)
	{
		destroy_bitmap(obs);
		obs = NULL;
	}
	if (prg0 != NULL)
	{
		destroy_bitmap(prg0);
		prg0 = NULL;
	}
	if (prg1 != NULL)
	{
		destroy_bitmap(prg1);
		prg1 = NULL;
	}
	if (lfont != NULL)
	{
		destroy_font(lfont);
		lfont = NULL;
	}	
	if (sfont != NULL)
	{
		destroy_font(sfont);
		sfont = NULL;
	}
	if (buffa != NULL)
	{
		destroy_bitmap(buffa);
		buffa = NULL;
	}
	allegro_exit();
}

void countache(void)
{
	int cnt;
	achemastercount = 0;
	for (cnt = 0; cnt < 30; cnt++)
	{
		if (achievements[cnt])
		{
			achemastercount++;
			if (achemastercount >= 10 && bonuslocked)
			{
				bonuslocked = 0;
				if (!achievements[7])
				{
					newachievements[7] = 1;
				}					
			}
			if (achemastercount >= 14)
			{
				if (!achievements[21])
				{
					newachievements[21] = 1;
				}					
			}
			if (achemastercount >= 18)
			{
				if (!achievements[22])
				{
					newachievements[22] = 1;
				}					
			}
			if (achemastercount >= 22)
			{
				if (!achievements[23])
				{
					newachievements[23] = 1;
				}					
			}
		}
	}	
}

void saveache(void)
{
	int cnt = 0;
	int boo;
	FILE *f = fopen("ache.dat", "wb");
	if (f == NULL)
	{
		return;
	}
	while (cnt < 30)
	{
		boo = fputc(achievements[cnt] ? 0xff : 0x00, f);
		if (boo == EOF)
		{
			fclose(f);
			return;
		}
		cnt++;
	}
	fclose(f);
}

void loadache(void)
{
	int cnt = 0;
	int boo;
	FILE *f = fopen("ache.dat", "rb");
	if (f != NULL)
	{
		while (cnt < 30)
		{
			boo = fgetc(f);
			if (boo == EOF)
			{
				fclose(f);
				f = NULL;
				break;
			}
			achievements[cnt] = boo ? 1 : 0;
			cnt++;
		}
		if (f != NULL)
		{
			fclose(f);
		}
	}	
	countache();
}

void checkache(void)
{
	int newaches = 0;
	int cnt;
	for (cnt = 0; cnt < 30; cnt++)
	{
		if (newachievements[cnt])
		{
			if (!achievements[cnt])
			{
				if (achecounter > 0 && achecounter < 100)
				{
					achecounter = 100;
				}
				else
				{
					achecounter = 120;
				}
				achievements[cnt] = newachievements[cnt];
				newaches = 1;
			}
		}
	}	
	if (achecounter > 0)
	{
		achecounter--;
	}
	if (achecounter == 0)
	{
		for (cnt = 0; cnt < 30; cnt++)
		{
			newachievements[cnt] = 0;
		}
		countache();
	}
	if (newaches == 1)
	{
		saveache();
	}
}

void drawache(void)
{
	int achenum = 0;
	int cnt;
	int top;
	int itop;
	int ex;
	for (cnt = 0; cnt < 30; cnt++)
	{
		if (newachievements[cnt] && achievements[cnt])
		{
			achenum++;
		}
	}
	if (achecounter > 100)
	{
		ex = (achecounter - 100);
		ex *= ex;
		itop = 205 + ex;
	}
	else
	{
		if (achecounter < 20)
		{
			ex = 20 - achecounter;
			ex *= ex;
			itop = 205 + ex;			
		}
		else
		{
			itop = 205;
			ex = 0;
		}
	}
	top = itop - (achenum * (text_height(sfont) + 1));	
	drawWindow(2, top, 317, 217 + ex, 2, 1, 1);
	top += 2;
	if (achenum == 1)
	{
		textprintf_centre_ex(buffa, sfont, 160,  top, achecounter % 4 ? 2 : 1, -1, "ACHIEVEMENT UNLOCKED");
	}
	else
	{
		textprintf_centre_ex(buffa, sfont, 160,  top, achecounter % 4 ? 2 : 1, -1, "ACHIEVEMENTS UNLOCKED");
	}
	top += 10;
	for (cnt = 0; cnt < 30; cnt++)
	{
		if (newachievements[cnt] && achievements[cnt])
		{
			textprintf_centre_ex(buffa, sfont, 160, top, 2, -1, achedesc[cnt]);
			top += text_height(sfont) + 1;
		}
	}
}

void startTheGame(void)
{
	int cnt;
	procGame = NULL;
	prevProcGame = NULL;	
	goToTitlescreen();
	//goToHomeopathy();
	//goToFaithHealing();
	setPalState(6);
	setSndState(6);
	for (cnt = 0; cnt < 30; cnt++)
	{
		butnaps[cnt] = NULL;
	}	
	for (cnt = 0; cnt < 30; cnt++)
	{
		newachievements[cnt] = 0;
		achievements[cnt] = 0;
	}	
	loadache();
	while (1)
	{
		if (timan60 != 0)
		{
			timerblink = 1;
			timan60 = 0;
		}
		if (timerblink == 1)
		{
			if (key[KEY_TAB])
			{
				dispfps = dispfps ? 0 : 1;
				key[KEY_TAB] = 0;
			}
			checkache();
			pollTrack();
			timan60 = 0;
			if (transi != 0)
			{
				acceptinput = 0;
				if (achecounter == 0)
				{
					cnt++;
				}
				if (cnt > 10)
				{
					cnt = 0;
					switch (transi)
					{
						case 1:
							if (palstate > 0)
							{
								setSndState(palstate - 1);
								setPalState(palstate - 1);
							}
							else
							{
								acceptinput = 1;
								clear_keybuf();
								transitionfinished = 1;
								transi = 0;								
							}
							break;
						case 2:
							if (palstate < 6)
							{
								setSndState(palstate + 1);
								setPalState(palstate + 1);
							}
							else
							{
								transi = 0;
							}
							break;
						default:
							break;
					}
				}
			}
			else
			{
				if (palstate != 6)
				{
					if (nextProcGame != procGame)
					{
						if (nextProcGame == NULL)
						{
							if (!achievements[1])
							{
								newachievements[1] = 1;
							}
						}
						transi = 2;
					}
				}
				else
				{
					prevProcGame = procGame;
					procGame = nextProcGame;
					if (procGame == NULL)
					{
						running = 0;
						break;
					}
					else
					{
						for (cnt = 0; cnt < 10; cnt++)
						{
							if (butnaps[cnt] != NULL)
							{
								destroy_bitmap(butnaps[cnt]);
								butnaps[cnt] = NULL;
							}
						}
						if (procInit != NULL)
						{
							procInit();
						}
						transi = 1;
					}
				}
			}
		}		
		clear_to_color(buffa, 4);
		if (acceptinput == 1 && !achievements[2])
		{
			if (keypressed())
			{
				newachievements[2] = 1;
			}
		}		
		if (procGame != NULL)
		{
			procGame();
		}
		if (achecounter > 0)
		{
			drawache();
		}
		if (dispfps)
		{
			if (procGame == procFaithHealing || procGame == procHomeopathy)
			{
				textprintf_ex(buffa, sfont, 3, 35, 1, -1, "FPS %d", cfps);
				textprintf_ex(buffa, sfont, 3, 34, 4, -1, "FPS %d", cfps);
			}
			else
			{
				textprintf_ex(buffa, sfont, 3, 4, 3, -1, "FPS %d", cfps);
				textprintf_ex(buffa, sfont, 3, 3, 1, -1, "FPS %d", cfps);
			}
		}
		stretch_blit(buffa, screen, 0, 0, 320, 240, 0, 0, 640, 480);
		rest(1);
		timerblink = 0;
		tfps++;
	}
	setSndState(6);
	setPalState(6);
}
