#include "sounds.h"
#include "smoothie.h"
#include <allegro.h>
#include <math.h>
#include <dumb.h>
#include <aldumb.h>

void (*borrmaskin)(void) = NULL;
AL_DUH_PLAYER *playa = NULL;
DUH *curtrack = NULL;
DUMBFILE *curfile = NULL;
unsigned char *curblob = NULL;
int sndstate = -1;
int hv = 64;
int lv = 10;
int nv = 0;

SAMPLE *plonk = NULL;
SAMPLE *plimplom = NULL;
SAMPLE *bewm = NULL;
SAMPLE *zappo = NULL;
SAMPLE *plink = NULL;

void initSound(void)
{
	unsigned int i;
	plonk = create_sample(8, 0, 44100, 2500);
	if (plonk != NULL)
	{
		for (i = 0; i < plonk->len; i++)
		{
			((unsigned char *)plonk->data)[i] = 128 + (int)(40.0f * (sin((float)i / 20.0f) * ((float)(plonk->len - i) / (float)plonk->len)));
		}
	}
	plimplom = create_sample(8, 0, 44100, 5000);
	if (plimplom != NULL)
	{
		for (i = 0; i < plimplom->len; i++)
		{
			if (i < (plimplom->len / 2))
			{
				((unsigned char *)plimplom->data)[i] = 128 + (int)(60.0f * (sin((float)i / 10.0f) * ((float)(plimplom->len - i) / (float)plimplom->len)));
			}
			else
			{
				((unsigned char *)plimplom->data)[i] = 128 + (int)(40.0f * (sin((float)i / 20.0f) * ((float)(plimplom->len - i) / (float)plimplom->len)));
			}
		}
	}
	bewm = create_sample(8, 0, 44100, 88200);
	if (bewm != NULL)
	{
		for (i = 0; i < bewm->len; i++)
		{
			((unsigned char *)bewm->data)[i] = 128 + (int)(60.0f * (sin((float)i / (50.0f + ((float)i / 200.0f))) * ((float)(bewm->len - i) / (float)bewm->len)));
		}
	}
	zappo = create_sample(8, 0, 44100, 11025);
	if (zappo != NULL)
	{
		for (i = 0; i < zappo->len; i++)
		{
			((unsigned char *)zappo->data)[i] = !((i / 100) % 2) ? 128 + (int)((float)i * 2.0f * ((float)(zappo->len - i) / (float)zappo->len)) : 128;
		}
	}
	plink = create_sample(8, 0, 44100, 2500);
	if (plink != NULL)
	{
		for (i = 0; i < plink->len; i++)
		{
			((unsigned char *)plink->data)[i] = 128 + (int)(40.0f * (sin((float)i / 5.0f) * ((float)(plink->len - i) / (float)plink->len)));
		}
	}	
}

void uninitSound(void)
{
	if (plink != NULL)
	{
		stop_sample(plink);
		destroy_sample(plink);
		plink = NULL;
	}		
	if (zappo != NULL)
	{
		stop_sample(zappo);
		destroy_sample(zappo);
		zappo = NULL;
	}		
	if (bewm != NULL)
	{
		stop_sample(bewm);
		destroy_sample(bewm);
		bewm = NULL;
	}	
	if (plimplom != NULL)
	{
		stop_sample(plimplom);
		destroy_sample(plimplom);
		plimplom = NULL;
	}
	if (plonk != NULL)
	{
		stop_sample(plonk);
		destroy_sample(plonk);
		plonk = NULL;
	}
}

void playSound(int id)
{
	switch (id)
	{
		case 0:
			if (plonk != NULL)
			{
				play_sample(plonk, 255, 128, 1000, 0);
			}
			break;
		case 1:
			if (plimplom != NULL)
			{
				play_sample(plimplom, 255, 128, 1000, 0);
			}
			break;
		case 2:
			if (bewm != NULL)
			{
				play_sample(bewm, 255, 128, 1000, 0);
			}
			break;
		case 3:
			if (zappo != NULL)
			{
				play_sample(zappo, 100, 128, 1000, 0);
			}
			break;
		case 4:
			if (plink != NULL)
			{
				play_sample(plink, 100, 128, 1000, 0);
			}
			break;				
	}
}

void loadTrack(int id)
{
	unloadTrack();
	curblob = (char *)smoothie(id);
	if (curblob != NULL)
	{
		curfile = dumbfile_open_memory(curblob + 2, (*(curblob + 1) << 8) | *curblob);
	}
	if (curfile != NULL)
	{
		curtrack = dumb_read_it(curfile);
	}
}

void unloadTrack(void)
{
	stopTrack();
	if (curtrack != NULL)
	{
		unload_duh(curtrack);
		curtrack = NULL;
	}
	if (curfile != NULL)
	{
		dumbfile_close(curfile);
		curfile = NULL;
	}
	if (curblob != NULL)
	{
		free(curblob);
		curblob = NULL;
	}
}

int durka(void *d, int ch, unsigned char b)
{
	d = NULL;
	ch = 0;
	b = 0;
	if (sndstate != 6 && sndstate != -1)
	{
		if (borrmaskin != NULL)
		{
			borrmaskin();
		}
	}
	return 1;
}

void startTrack(void)
{
	DUH_SIGRENDERER *rn;
	DUMB_IT_SIGRENDERER *ri;
	stopTrack();
	if (curtrack != NULL)
	{
		playa = al_start_duh(curtrack, 2, 0, 1.0f, 1024, 44100);
		if (borrmaskin != NULL)
		{
			rn = al_duh_get_sigrenderer(playa);
			if (rn != NULL)
			{
				ri = duh_get_it_sigrenderer(rn);
				if (ri != NULL)
				{
					dumb_it_set_midi_callback(ri, durka, NULL);
				}
			}
		}
	}
}

void stopTrack(void)
{
	if (playa != NULL)
	{
		al_stop_duh(playa);
		playa = NULL;
	}
}

void pollTrack(void)
{
	if (playa != NULL)
	{
		al_poll_duh(playa);
	}
}

void setSndState(int st)
{
	DUH_SIGRENDERER *rn;
	DUMB_IT_SIGRENDERER *ri;
	if (playa == NULL || sndstate == st)
	{
		sndstate = st;
		return;
	}
	rn = al_duh_get_sigrenderer(playa);
	if (rn == NULL)
	{
		sndstate = st;
		return;
	}
	ri = duh_get_it_sigrenderer(rn);
	if (ri == NULL)
	{
		sndstate = st;
		return;
	}
	switch (st)
	{
		case 0:
			dumb_it_sr_set_channel_volume(ri, 0, hv);
			dumb_it_sr_set_channel_volume(ri, 1, hv);
			dumb_it_sr_set_channel_volume(ri, 2, hv);
			dumb_it_sr_set_channel_volume(ri, 3, hv);
			break;
		case 1:
			dumb_it_sr_set_channel_volume(ri, 0, lv);
			dumb_it_sr_set_channel_volume(ri, 1, lv);
			dumb_it_sr_set_channel_volume(ri, 2, hv);
			dumb_it_sr_set_channel_volume(ri, 3, hv);
			break;
		case 2:
			dumb_it_sr_set_channel_volume(ri, 0, lv);
			dumb_it_sr_set_channel_volume(ri, 1, lv);
			dumb_it_sr_set_channel_volume(ri, 2, lv);
			dumb_it_sr_set_channel_volume(ri, 3, hv);
			break;
		case 3:
			dumb_it_sr_set_channel_volume(ri, 0, lv);
			dumb_it_sr_set_channel_volume(ri, 1, lv);
			dumb_it_sr_set_channel_volume(ri, 2, lv);
			dumb_it_sr_set_channel_volume(ri, 3, lv);
			break;
		case 4:
			dumb_it_sr_set_channel_volume(ri, 0, nv);
			dumb_it_sr_set_channel_volume(ri, 1, lv);
			dumb_it_sr_set_channel_volume(ri, 2, lv);
			dumb_it_sr_set_channel_volume(ri, 3, lv);
			break;	
		case 5:
			dumb_it_sr_set_channel_volume(ri, 0, nv);
			dumb_it_sr_set_channel_volume(ri, 1, nv);
			dumb_it_sr_set_channel_volume(ri, 2, lv);
			dumb_it_sr_set_channel_volume(ri, 3, lv);
			break;
		case 6:
			dumb_it_sr_set_channel_volume(ri, 0, nv);
			dumb_it_sr_set_channel_volume(ri, 1, nv);
			dumb_it_sr_set_channel_volume(ri, 2, nv);
			dumb_it_sr_set_channel_volume(ri, 3, nv);
			stopTrack();
			break;			
		default:
			return;
	}
	sndstate = st;
}

void asdf(void (*qqqq)(void))
{
	borrmaskin = qqqq;
}
