#include "parts.h"
#include <math.h>
#include <allegro.h>
#include "thegame.h"
#include "smoothie.h"

struct
{
	float x, y;
	float dir, vel;
	int ttl, mttl;
} partsy[100];

BITMAP *boo[5] = { NULL };

void initParts(void)
{
	int i;
	boo[0] = smoothie(2);
	boo[1] = smoothie(3);
	boo[2] = smoothie(4);
	boo[3] = smoothie(5);
	boo[4] = smoothie(6);
	for (i = 0; i < 100; i++)
	{
		partsy[i].ttl = 0;
	}
}

void uninitParts(void)
{
	int i;
	for (i = 0; i < 5; i++)
	{
		if (boo[i] != NULL)
		{
			destroy_bitmap(boo[i]);
			boo[i] = NULL;
		}
	}
}

void updateParticles(void)
{
	int i;
	for (i = 0; i < 100; i++)
	{
		if (partsy[i].ttl > 0)
		{
			partsy[i].x += cos(partsy[i].dir) * partsy[i].vel;
			partsy[i].y += sin(partsy[i].dir) * partsy[i].vel;
			partsy[i].ttl--;
		}
	}
}

void drawParticles(void)
{
	int i;
	float st;
	BITMAP *boox;
	for (i = 0; i < 100; i++)
	{
		if (partsy[i].ttl > 0)
		{
			st = ((float)partsy[i].ttl / (float)partsy[i].mttl);
			if (st > 0.8)
			{
				boox = boo[0];
			}
			else if (st > 0.6)
			{
				boox = boo[1];
			}
			else if (st < 0.2)
			{
				boox = boo[4];
			}
			else if (st < 0.4)
			{
				boox = boo[3];
			}
			else
			{
				boox = boo[2];
			}
			draw_sprite(buffa, boox, (int)partsy[i].x - (boox->w / 2), (int)partsy[i].y - (boox->h / 2));
		}
	}
}

void setData(int i, float x, float y, float dir, float vel, int ttl, int mttl)
{
	partsy[i].x = x;
	partsy[i].y = y;
	partsy[i].dir = dir;
	partsy[i].vel = vel;
	partsy[i].ttl = ttl;
	partsy[i].mttl = mttl;
}
