#include "fth.h"
#include <allegro.h>
#include <stdio.h>
#include "common.h"
#include "sounds.h"
#include "amath.h"
#include "thegame.h"
#include "smoothie.h"

int curSeconds;
int curMinutes;
int curHours;
int curDays;
int curYears;
int maxSeconds;
int maxMinutes;
int maxHours;
int maxDays;
int maxYears;
int seccn;
int started;
int newMaxChain;
int menuOpen;
int menusel;
int juststarted;
int showinfo;
int zoomer;

void savemax(void)
{
	int boo;
	FILE *f = fopen("max.dat", "wb");
	if (f == NULL)
	{
		return;
	}
	boo = fputc(maxSeconds, f);
	if (boo == EOF)
	{
		fclose(f);
		return;
	}
	boo = fputc(maxMinutes, f);
	if (boo == EOF)
	{
		fclose(f);
		return;
	}
	boo = fputc(maxHours, f);
	if (boo == EOF)
	{
		fclose(f);
		return;
	}
	boo = fputc(maxDays & 0xff, f);
	if (boo == EOF)
	{
		fclose(f);
		return;
	}
	boo = fputc((maxDays >> 8) & 0xff, f);
	if (boo == EOF)
	{
		fclose(f);
		return;
	}
	boo = fputc(maxYears & 0xff, f);
	if (boo == EOF)
	{
		fclose(f);
		return;
	}
	boo = fputc((maxYears >> 8) & 0xff, f);
	if (boo == EOF)
	{
		fclose(f);
		return;
	}
	fclose(f);
}

void loadmax(void)
{
	int boo;
	FILE *f = fopen("max.dat", "rb");
	if (f != NULL)
	{
		boo = fgetc(f);
		if (boo == EOF)
		{
			fclose(f);
			return;
		}
		maxSeconds = boo;
		boo = fgetc(f);
		if (boo == EOF)
		{
			fclose(f);
			return;
		}
		maxMinutes = boo;
		boo = fgetc(f);
		if (boo == EOF)
		{
			fclose(f);
			return;
		}
		maxHours = boo;		
		boo = fgetc(f);
		if (boo == EOF)
		{
			fclose(f);
			return;
		}
		maxDays = boo & 0xff;
		boo = fgetc(f);
		if (boo == EOF)
		{
			fclose(f);
			return;
		}
		maxDays |= (boo & 0xff) << 8;
		boo = fgetc(f);
		if (boo == EOF)
		{
			fclose(f);
			return;
		}
		maxYears = boo & 0xff;
		boo = fgetc(f);
		if (boo == EOF)
		{
			fclose(f);
			return;
		}
		maxYears |= (boo & 0xff) << 8;
		fclose(f);
	}	
}

void initFaithHealing(void)
{
	setPalState(6);
	setSndState(6);
	curSeconds = 0;
	curMinutes = 0;
	curHours = 0;
	curDays = 0;
	curYears = 0;
	maxSeconds = 0;
	maxMinutes = 0;
	maxHours = 0;
	maxDays = 0;
	maxYears = 0;
	seccn = 0;
	started = 0;
	newMaxChain = 0;
	menuOpen = 0;
	butnaps[0] = smoothie(15);
	butnaps[1] = smoothie(16);
	butnaps[2] = smoothie(12);
	butnaps[3] = create_bitmap_ex(8, 133, 67);
	clear_to_color(butnaps[3], 0);
	draw_sprite(butnaps[3], butnaps[0], 0, 31);
	draw_sprite(butnaps[3], butnaps[1], 53, 0);
	loadmax();
	juststarted = 1;
	showinfo = 0;
	zoomer = 0;
}

static void secondtick(int num)
{
	curSeconds += num;
	while (curSeconds >= 60)
	{
		if (zoomer == 0)
		{
			zoomer = 300;
		}
		if (!achievements[9])
		{
			newachievements[9] = 1;
		}
		curMinutes++;
		curSeconds -= 60;
	}
	while (curMinutes >= 60)
	{
		if (!achievements[10])
		{
			newachievements[10] = 1;
		}
		curHours++;
		curMinutes -= 60;
	}
	while (curHours >= 24)
	{
		if (!achievements[11])
		{
			newachievements[11] = 1;
		}
		curDays++;
		curHours -= 24;
	}
	while (curDays >= 365)
	{
		if (!achievements[12])
		{
			newachievements[12] = 1;
		}
		curYears++;
		if (curYears > 999) {
			curYears = 999;
			if (!achievements[13])
			{
				newachievements[13] = 1;
			}			
		}
		curDays -= 365;
	}	
}

void newResult(void)
{
	unsigned int whoa = 0, hurr = 0;
	if (curYears > maxYears)
	{
		maxYears = curYears;
		maxDays = curDays;
		maxHours = curHours;
		maxMinutes = curMinutes;
		maxSeconds = curSeconds;
		newMaxChain = 60;
		savemax();
	}
	if (curYears == maxYears)
	{
		whoa += curSeconds;
		whoa += curMinutes * 60;
		whoa += curHours * 60 * 60;
		whoa += curDays * 60 * 60 * 24;
		hurr += maxSeconds;
		hurr += maxMinutes * 60;
		hurr += maxHours * 60 * 60;
		hurr += maxDays * 60 * 60 * 24;
		if (whoa > hurr)
		{
			maxDays = curDays;
			maxHours = curHours;
			maxMinutes = curMinutes;
			maxSeconds = curSeconds;
			newMaxChain = 60;
			savemax();
		}
	}
	curYears = 0;
	curDays = 0;
	curHours = 0;
	curMinutes = 0;
	curSeconds = 0;	
}

void procFaithHealing(void)
{
	int x, y;
	float scale;
	drawBasicGameplay();
	textprintf_ex(buffa, sfont, 3, 3, 2, -1, "ELAPSED");
	if (newMaxChain > 0)
	{
		textprintf_ex(buffa, sfont, 264, 3, newMaxChain % 4 ? 2 : 1, -1, "MAX CHAIN");
	}
	else
	{
		textprintf_ex(buffa, sfont, 264, 3, 2, -1, "MAX CHAIN");
	}
	textprintf_ex(buffa, sfont, 3, 219, 2, -1, "PROGRESS");
	if (transitionfinished == 1)
	{
		loadTrack(17);
		asdf(NULL);
		startTrack();
		transitionfinished = 0;
	}	
	if (timerblink)
	{
		if (!menuOpen)
		{
			if (zoomer > 0)
			{
				zoomer--;
			}
		}
		if (newMaxChain > 0)
		{
			newMaxChain--;
		}
		if (acceptinput)
		{
			if (juststarted)
			{
				juststarted = 0;
				showinfo = 1;
			}
			if (showinfo)
			{
				if (key[KEY_ENTER] || key[KEY_SPACE])
				{
					showinfo = 0;
					key[KEY_ENTER] = 0;
					key[KEY_SPACE] = 0;
				}					
			}
			else if (menuOpen)
			{
				if (key[KEY_UP])
				{
					playSound(0);
					menusel--;
					if (menusel < 0) {
						menusel = 1;
					}
					key[KEY_UP] = 0;
				}
				if (key[KEY_DOWN])
				{
					playSound(0);
					menusel++;
					key[KEY_DOWN] = 0;
					if (menusel > 1) {
						menusel = 0;
					}
				}
				if (key[KEY_ENTER] || key[KEY_SPACE])
				{
					playSound(1);
					switch (menusel)
					{
						case 0:
							menuOpen = 0;
							break;
						case 1:
							goToAftermath();
							break;
					}
					key[KEY_ENTER] = 0;
					key[KEY_SPACE] = 0;
				}				
			}
			else
			{
				if (key[KEY_SPACE])
				{
					if (!achievements[8])
					{
						newachievements[8] = 1;
					}									
					started = 1;
					if (!fastheal)
					{
						seccn++;
						while (seccn >= 60)
						{
							secondtick(1);
							seccn -= 60;
						}
					}
					else
					{
						secondtick(99999);
					}
				}
				else
				{
					if (started)
					{
						seccn = 0;
						started = 0;
						newResult();
					}
					if (key[KEY_ESC])
					{
						menuOpen = 1;
						menusel = 0;
					}
				}
			}
		}
	}
	if (zoomer > 0)
	{
		y = 30;
		if (zoomer > 240)
		{
			scale = 2.0f - ((float)(zoomer - 240) / 60.0f);
		}
		else if (zoomer < 60)
		{
			scale = 1.0f + ((float)zoomer / 60.0f);
		}
		else
		{
			scale = 2.0f;
		}
		masked_stretch_blit(butnaps[3], buffa, 0, 0, butnaps[3]->w, butnaps[3]->h, 160 - (int)(((float)butnaps[3]->w / 2.0f) * scale), 120 - (int)(((float)butnaps[3]->h / 2.0f) * scale), (int)((float)butnaps[3]->w * scale), (int)((float)butnaps[3]->h * scale));
		drawWindow(4, y, 315, y + 8, 1, 0, 0);
		textprintf_centre_ex(buffa, sfont, 160, y + 2, 2, -1, "ACTION CLOSE UP");
	}
	else
	{
		draw_sprite(buffa, butnaps[3], 160 - (butnaps[3]->w / 2), 120 - (butnaps[3]->h / 2));
	}
	if (!juststarted && !showinfo && !started)
	{
		x = 49;
		y = 174;
		drawWindow(x, y, x + 223, y + 26, 1, 1, 0);
		textprintf_ex(buffa, sfont, x + 19, y + 2, 2, -1, "PRESS AND HOLD SPACE TO EXECUTE");
		textprintf_ex(buffa, sfont, x + 19, y + 8, 2, -1, "WHATEVER ACTIONS ARE CONSIDERED");
		textprintf_ex(buffa, sfont, x + 19, y + 14, 2, -1, "NECESSARY TO PERFORM FAITH HEALING");
		textprintf_ex(buffa, sfont, x + 19, y + 20, 2, -1, "IN THE FAITH OF YOUR CHOOSING");
	}
	drawBar(3, 316, 225, 0, 1, 0);
	displaytime(3, 9, &curYears, &curDays, &curHours, &curMinutes, &curSeconds);
	displaytime(180, 9, &maxYears, &maxDays, &maxHours, &maxMinutes, &maxSeconds);
	if (menuOpen)
	{
		drawShade(1);
		y = 80;
		drawWindow(101, y, 218, y + 71, 1, 0, 0);
		textprintf_centre_ex(buffa, lfont, 160, y + 2, 2, -1, "REALLY QUIT");
		textprintf_centre_ex(buffa, sfont, 160, y + 22, 2, -1, "LIVES DEPEND ON YOU");
		textprintf_centre_ex(buffa, sfont, 160, y + 28, 2, -1, "DO NOT BE A QUITTER");
		textprintf_centre_ex(buffa, lfont, 160, y + 42, 3, -1, "NO");
		textprintf_centre_ex(buffa, lfont, 160, y + 57, 3, -1, "YES");
		textprintf_centre_ex(buffa, lfont, 160, y + 41, 1, -1, "NO");
		textprintf_centre_ex(buffa, lfont, 160, y + 56, 1, -1, "YES");
		if (nextProcGame == procFaithHealing)
		{
			draw_sprite(buffa, butnaps[2], 130 - (butnaps[2]->w / 2), y + 47 + (15 * menusel) - (butnaps[2]->h / 2));
			draw_sprite(buffa, butnaps[2], 190 - (butnaps[2]->w / 2), y + 47 + (15 * menusel) - (butnaps[2]->h / 2));
		}
	}
	if (showinfo)
	{
		y = 70;
		drawWindow(30, y, 290, y + 108, 1, 0, 0);
		y += 2;
		textprintf_centre_ex(buffa, lfont, 160, y + 1, 3, -1, "FAITH HEALING");
		textprintf_centre_ex(buffa, lfont, 160, y, 1, -1, "FAITH HEALING");
		y += text_height(lfont) + 10;
		textprintf_centre_ex(buffa, sfont, 160, y, 2, -1, "YOUR GOAL IS TO PERFORM WHATEVER ACTIONS");
		y += text_height(sfont) + 2;
		textprintf_centre_ex(buffa, sfont, 160, y, 2, -1, "ARE CONSIDERED NECESSARY TO PERFORM FAITH");
		y += text_height(sfont) + 2;
		textprintf_centre_ex(buffa, sfont, 160, y, 2, -1, "HEALING IN THE FAITH OF YOUR CHOOSING");
		y += (text_height(sfont) * 2) + 4;
		textprintf_centre_ex(buffa, sfont, 160, y, 2, -1, "THE DISEASE AND AILMENT CAN ALSO BE FREELY");
		y += text_height(sfont) + 2;
		textprintf_centre_ex(buffa, sfont, 160, y, 2, -1, "CHOSEN");
		y += (text_height(sfont) * 2) + 4;
		textprintf_centre_ex(buffa, sfont, 160, y, 2, -1, "WHEN THE DISEASE OR AILMENT HAS BEEN CURED");
		y += text_height(sfont) + 2;
		textprintf_centre_ex(buffa, sfont, 160, y, 2, -1, "THE PERSON CURED WILL WALK FORWARD AND SIT");
		y += text_height(sfont) + 2;
		textprintf_centre_ex(buffa, sfont, 160, y, 2, -1, "IN THAT CHAIR");
		y += (text_height(sfont) * 2) + 4;
		textprintf_centre_ex(buffa, sfont, 160, y + 1, 3, -1, "PRESS SPACE TO CONTINUE");
		textprintf_centre_ex(buffa, sfont, 160, y, 1, -1, "PRESS SPACE TO CONTINUE");
	}	
}

void goToFaithHealing(void)
{
	procInit = initFaithHealing;
	nextProcGame = procFaithHealing;	
}
