#include "amath.h"
#include <allegro.h>
#include <stdio.h>
#include "thegame.h"
#include "sounds.h"
#include "common.h"
#include "titlescr.h"
#include "smoothie.h"
#include "fth.h"
#include "hom.h"

int tc;

void initAftermath(void)
{
	setPalState(6);
	setSndState(6);
	tc = 0;
	butnaps[0] = smoothie(15);
	butnaps[1] = smoothie(16);
	butnaps[2] = smoothie(12);
}

void showcounter(int y, int r)
{
	int x, n, i;
	if (r)
	{
		x = 270;
		for (i = 0; i < 20; i++)
		{
			n = rand() % 10;
			textprintf_right_ex(buffa, lfont, x, y, 2, -1, "%d", n);
			x -= text_length(lfont, "0");
		}
	}
	else
	{
		textprintf_right_ex(buffa, lfont, 270, y, 3, -1, "00000000000000000000");
		textprintf_right_ex(buffa, lfont, 270, y, 2, -1, "0");
	}
}

void procAftermath(void)
{
	if (timerblink)
	{
		if (acceptinput)
		{
			if (key[KEY_SPACE] || key[KEY_ENTER] || key[KEY_ESC])
			{
				key[KEY_SPACE] = 0;
				key[KEY_ENTER] = 0;
				key[KEY_ESC] = 0;
				if (tc < 330)
				{
					tc = 330;
				}
				else
				{
					goToTitlescreen();
				}
			}
		}
		if (tc < 330)
		{
			tc++;
		}
	}
	if (transitionfinished == 1)
	{
		loadTrack(21);
		asdf(NULL);
		startTrack();
		transitionfinished = 0;
	}
	drawWindow(10, 10, 309, 223, 2, 0, 0);
	textprintf_centre_ex(buffa, lfont, 160, 21, 3, -1, "AFTERMATH");
	textprintf_centre_ex(buffa, lfont, 160, 20, 1, -1, "AFTERMATH");
	if (prevProcGame == procFaithHealing)
	{
		textprintf_ex(buffa, sfont, 50, 50, 2, -1, "DISEASES AND AILMENTS CURED");
		showcounter(56, tc < 180);
		textprintf_ex(buffa, sfont, 50, 80, 2, -1, "LIMBS REGENERATED");
		showcounter(86, tc < 230);
		textprintf_ex(buffa, sfont, 50, 110, 2, -1, "RESURRECTIONS");
		showcounter(116, tc < 280);		
		textprintf_ex(buffa, sfont, 50, 140, 2, -1, "LIVES SAVED");
		showcounter(146, tc < 330);
	}
	if (prevProcGame == procHomeopathy)
	{
		textprintf_ex(buffa, sfont, 50, 50, 2, -1, "ACTUAL CURES CREATED");
		showcounter(56, tc < 180);
		textprintf_ex(buffa, sfont, 50, 80, 2, -1, "DISEASES AND AILMENTS CURED");
		showcounter(86, tc < 230);
		textprintf_ex(buffa, sfont, 50, 110, 2, -1, "EPIMEDICS AND PANDEMICS THWARTED");
		showcounter(116, tc < 280);		
		textprintf_ex(buffa, sfont, 50, 140, 2, -1, "LIVES SAVED");
		showcounter(146, tc < 330);
	}
	textprintf_centre_ex(buffa, sfont, 160, 214 - text_height(sfont), 3, -1, "PRESS SPACE TO CONTINUE");
	textprintf_centre_ex(buffa, sfont, 160, 213 - text_height(sfont), 1, -1, "PRESS SPACE TO CONTINUE");
}

void goToAftermath(void)
{
	procInit = initAftermath;
	nextProcGame = procAftermath;
}
