// TETGUI

#ifndef _TETGUI_H
#define _TETGUI_H

#include <allegro.h>

extern DATAFILE *guidat;

struct appearance
{
   int c1, c2, c3, fontc;						// normal colors
   int mc1, mc2, mc3, mfontc;					// mouseover colors
   int ptc1, ptc2, ptc3, ptfontc;			// pressed/toggled colors
   int borderc;									// border color
   FONT *f;											// font
   int dc1, dc2, dc3, dfontc, dborderc;	// disabled - colors
};

const char DISABLED = 1;
const char DRAW = 2;
const char MOUSEOVER = 4;
const char PRESSED = 8;
const char TOGGLED = 16;

class dialog;

class control
{
   friend class dialog;
	friend void draw_focus();

   public:
    control(dialog *_dlg = NULL);
    virtual ~control() {}

    virtual void update(){}
    virtual void draw(BITMAP *bmp){}
    virtual void draw_focus(BITMAP *bmp, int color){}
 
    virtual void refresh() {}
    virtual void disable() { flags |= DISABLED; lose_focus(); }
    virtual void enable() { flags ^= DISABLED; }

    inline bool disabled() { return getflag(DISABLED); }
    inline bool enabled() { return !getflag(DISABLED); }
    dialog* get_dlg() { return(dlg); }
    bool has_focus();
    void lose_focus();

	protected:
    void take_focus(bool demand = false);

    inline bool getflag(char N) { return(flags & N ? 1 : 0); }
    inline void setflag(char N) { flags |= N; }
    inline void unsetflag(char N) { flags ^= N; }

    char flags;
    dialog *dlg;
};

class static_control : public control
{
  public:
   static_control(int _x, int _y, int _drawx, int _drawy, int _w, int _h, dialog *_dlg = NULL);
   static_control(int _x, int _y, int _w, int _h, dialog *_dlg = NULL);

	virtual void draw_focus(BITMAP *bmp, int color);
   virtual void refresh() { flags |= DRAW; }
   virtual void disable() { flags |= DISABLED+DRAW; lose_focus(); }
   virtual void enable() { flags ^= DISABLED; flags |= DRAW; }

  protected:
	int x, y, drawx, drawy, w, h, x2, y2, drawx2, drawy2;
};

class mouse_control : public static_control
{
   public:
    mouse_control(int _x, int _y, int _drawx, int _drawy, int _w, int _h, dialog *_dlg = NULL);
    mouse_control(int _x, int _y, int _w, int _h, dialog *_dlg = NULL);
    virtual bool mouseover() { return getflag(MOUSEOVER); }
    virtual bool pressed() { return getflag(PRESSED); }

   protected:
    bool mouse_over();
    bool mouse_click();

    virtual bool mouse_over_check();
    virtual bool lose_mouse_over_check();
    virtual bool press_check();
    virtual bool release_check();
};

class toggle_control : public mouse_control
{
   public:
    toggle_control(int _x, int _y, int _drawx, int _drawy, int _w, int _h, dialog *_dlg);
    toggle_control(int _x, int _y, int _w, int _h, dialog *_dlg);

    virtual bool toggled() = NULL;
    virtual void toggle() = NULL;
    virtual void untoggle() = NULL;
};

#include <list.h>

class dialog
{
	friend void draw_focus();

   public:
    dialog();
    ~dialog() {};
    void update();
    void draw(BITMAP *bmp);
    void refresh();
	 bool active();
    void activate();
    void deactivate();
    void add(control *control);
    void remove(control *control);

   private:
    list <control*> controls;
    bool _active;
};

class control_shortkey
{
	public:
	 control_shortkey(int __key) { _key = __key; }
	 void set_shortkey(int __key) { _key = __key; }
	 bool press();

	private:
    int _key;
};

class shortkey : public control
{
	public:
    shortkey(void(*_func)(), int __key, dialog *_dlg = NULL);
	 void update();

   protected:
    void(*func)();
	 control_shortkey _shortkey;
};

class button : public mouse_control
{
	public:
	 button(int _x, int _y, int _drawx, int _drawy, int _w, int _h, char* _text, appearance *_a, dialog *_dlg = NULL);
	 button(int _x, int _y, int _w, int _h, char* _text, appearance *_a, dialog *_dlg = NULL);
	 void update();
	 void draw(BITMAP *bmp);
    void set_callback(void(*func)(button *b)) { callback = func; }

	protected:
    void(*callback)(button *b);
    appearance *a;
    char* text;
};

class static_box : public static_control
{
	public:
	 static_box(int _x, int _y, int _w, int _h, appearance *_a, dialog *_dlg = 0);
	 void draw(BITMAP *bmp);

	protected:
    char *text;
    appearance *a;
};

class static_textbox : public static_control
{
	public:
	 static_textbox(int _x, int _y, int _w, int _h, char* _text, appearance *_a, dialog *_dlg = 0);
	 void draw(BITMAP *bmp);

	protected:
    char *text;
    appearance *a;
};

class static_bitmap : public static_control
{
	public:
	 static_bitmap(int _x, int _y, int _w, int _h, int _bitmap, bool _maskedblit = false, dialog *_dlg = 0);
	 void draw(BITMAP *bmp);

	protected:
    int bitmap;
    bool maskedblit;
};

class static_text : public static_control
{
	public:
    static_text(int _x, int _y, char* _text, appearance *_a, dialog *_dlg = 0);
	 void draw(BITMAP *bmp);

   private:
    char *text;
    appearance *a;
};

class checkbox : public toggle_control
{
   public:
    checkbox(int _x, int _y, int _drawx, int _drawy, appearance *_a, bool _toggled, dialog *_dlg);
    checkbox(int _x, int _y, appearance *_a, bool _toggled, dialog *_dlg);
    void draw(BITMAP *bmp);
    void update();

    bool toggled() { return(getflag(TOGGLED)); }
	 void toggle()  { setflag(TOGGLED); }
	 void untoggle() { unsetflag(TOGGLED); }

   private:
    appearance *a;
    void draw_checkmark(BITMAP *bmp, int x, int y, int col);
};

class slider : public mouse_control
{
	public:
    slider(int _x, int _y, int _drawx, int _drawy, int _w, int _h, appearance *_a, int _minval, int _maxval, int __value, dialog *_dlg = NULL);
    slider(int _x, int _y, int _w, int _h, appearance *_a, int _minval, int _maxval, int _value, dialog *_dlg = NULL);

    void set_value(int __value);
    int get_value();
    void inc(int n=1);
    void dec(int n=1);

	 void change_value_range(int newmin, int newmax);
    void inc_value_range(int amount=1);
    void dec_value_range(int amount=1);

	protected:
    appearance *a;
	 int maxval, minval, value, ptrsize, minptrsize, maxptrsize;
    float pixpv;

	 virtual void calc_ptr_size() {}
};

class hslider : public slider
{
	public:
    hslider(int _x, int _y, int _drawx, int _drawy, int _w, int _h, appearance *_a, int _minval, int _maxval, int __value, dialog *_dlg = NULL);
    hslider(int _x, int _y, int _w, int _h, appearance *_a, int _minval, int _maxval, int __value, dialog *_dlg = NULL);

	 virtual void draw(BITMAP *bmp);
    virtual void update();
	 void refresh();

	protected:
	 button lbutton, rbutton;
	 void calc_ptr_size();
};

extern bool _shortkeys_disabled;
extern control *focus, *lastfocus;

#endif
