#include <allegro.h>

/* additional drawing primitives */

const int corner_rad = 10;

/* puts 4 pixels (used by rounded rectangle function) */

void put4pixel(BITMAP *bmp, int x, int y, int color)
{
	putpixel(bmp, x,y, color);
	putpixel(bmp, x+1,y, color);
	putpixel(bmp, x,y+1, color);
	putpixel(bmp, x+1,y+1, color);
}

/* draws a rectangle with rounded edges */

void rounded_rect(BITMAP *bmp, int x1, int y1, int x2, int y2, int color)
{
	// draw rounded edges
   do_arc(bmp, x1+corner_rad, y1+corner_rad, itofix(64), itofix(128), corner_rad, color, put4pixel);
   do_arc(bmp, x2-corner_rad-1, y1+corner_rad, itofix(0), itofix(64), corner_rad, color, put4pixel);
   do_arc(bmp, x1+corner_rad, y2-corner_rad-1, itofix(128), itofix(192), corner_rad, color, put4pixel);
   do_arc(bmp, x2-corner_rad-1, y2-corner_rad-1, itofix(192), itofix(256), corner_rad, color, put4pixel);
   // lines between edges
   // top
	hline(bmp, x1+corner_rad+2, y1, x2-corner_rad-1, color);
	hline(bmp, x1+corner_rad+2, y1+1, x2-corner_rad-1, color);
   // bottom
	hline(bmp, x1+corner_rad+3, y2-1, x2-corner_rad-2, color);
	hline(bmp, x1+corner_rad+3, y2, x2-corner_rad-2, color);
   // left
	vline(bmp, x1, y1+corner_rad, y2-corner_rad, color);
	vline(bmp, x1+1, y1+corner_rad, y2-corner_rad, color);
	// right
	vline(bmp, x2, y1+corner_rad, y2-corner_rad, color);
	vline(bmp, x2-1, y1+corner_rad, y2-corner_rad, color);
}

void rounded_box(BITMAP *bmp, int x1, int y1, int x2, int y2, int rc, int fc)
{
   circlefill(bmp, x1+corner_rad, y1+corner_rad, corner_rad, fc);
   circlefill(bmp, x2-corner_rad, y1+corner_rad, corner_rad, fc);
   circlefill(bmp, x1+corner_rad, y2-corner_rad, corner_rad, fc);
   circlefill(bmp, x2-corner_rad, y2-corner_rad, corner_rad, fc);
	rectfill(bmp,x1+2, y1+2+corner_rad, x1+corner_rad, y2-1-corner_rad, fc);
	rectfill(bmp,x2-corner_rad, y1+2+corner_rad, x2-2, y2-1-corner_rad, fc);
   rectfill(bmp,x1+corner_rad, y1+2, x2-corner_rad, y2-2, fc);
	rounded_rect(bmp, x1, y1, x2, y2, rc);
}

void _textout (BITMAP *bmp, FONT *f, char *text, int x, int y, int w, int h, int col)
{
	textout_centre (bmp, f, text, x + w/2, y + h/2 - text_height(f)/2, col);
}


