// tetgui.cpp

#include "tetgui.h"

bool _shortkeys_disabled;
control *focus, *lastfocus;
DATAFILE *guidat;

#include "dprimitives.h"

/* control */
             
void control::take_focus(bool demand = false)
{
	if(demand == true)
   {
   	if(dlg != NULL)
      {
	   	_shortkeys_disabled = true;
   		focus = this;
      }
   }
   else if (dlg != NULL) focus = this;
}

void control::lose_focus()
{
	if(focus == this) { focus = NULL; _shortkeys_disabled = false; }
}

bool control::has_focus()
{
	return(focus==this);
}

control::control (dialog *_dlg = NULL)
: flags(0)
{
	if (_dlg != NULL) _dlg->add(this);
   	else dlg = NULL;
}

/* static control */

static_control::static_control(int _x, int _y, int _drawx, int _drawy, int _w, int _h, dialog *_dlg = NULL)
: control(_dlg),
x(_x), y(_y), drawx(_drawx), drawy(_drawy), w(_w), h(_h), x2(_x+(_w-1)), y2(_y+(_h-1)), drawx2(_drawx+(_w-1)), drawy2(_drawy+(_h-1))
{
	setflag(DRAW);
}

static_control::static_control(int _x, int _y, int _w, int _h, dialog *_dlg = NULL)
: control(_dlg),
x(_x), y(_y), drawx(_x), drawy(_y), w(_w), h(_h), x2(_x+(_w-1)), y2(_y+(_h-1)), drawx2(_x+(_w-1)), drawy2(_y+(_h-1))
{
	setflag(DRAW);
}

void static_control::draw_focus(BITMAP *bmp, int color)
{
	rect(bmp, drawx, drawy, drawx2, drawy2, color);
}

/* mouse control */

mouse_control::mouse_control(int _x, int _y, int _drawx, int _drawy, int _w, int _h, dialog *_dlg = NULL)
: static_control(_x, _y, _drawx, _drawy, _w, _h, _dlg)
{
}

mouse_control::mouse_control(int _x, int _y, int _w, int _h, dialog *_dlg = NULL)
: static_control(_x, _y, _w, _h, _dlg)
{
}

bool mouse_control::mouse_over()
{
	return (mouse_x >= x && mouse_x <= x2 && mouse_y >= y && mouse_y <= y2);
}

bool mouse_control::mouse_click()
{
	return (mouse_x >= x && mouse_x <= x2 && mouse_y >= y && mouse_y <= y2 && mouse_b&1);
}

bool mouse_control::press_check()
{
	if (mouse_click() && !getflag(PRESSED))
   {
   	setflag(PRESSED);
      refresh();
      return(true);
	}

   return(false);
}

bool mouse_control::release_check()
{
	if (getflag(PRESSED) && !mouse_click())
   {
   	unsetflag(PRESSED);
		refresh();
      if(mouse_over()) return(true);
	}

   return(false);
}

bool mouse_control::mouse_over_check()
{
	if(mouse_over() && !getflag(MOUSEOVER))
   {
	   setflag(MOUSEOVER);
      refresh();
      return(true);
	}

   return(false);
}

bool mouse_control::lose_mouse_over_check()
{
	if(getflag(MOUSEOVER) && !mouse_over())
   {
	   unsetflag(MOUSEOVER);
      refresh();
      return(true);
	}

   return(false);
}

/* toggle control */

toggle_control::toggle_control(int _x, int _y, int _drawx, int _drawy, int _w, int _h, dialog *_dlg = NULL)
: mouse_control(_x, _y, _drawx, _drawy, _w, _h, _dlg)
{
}

toggle_control::toggle_control(int _x, int _y, int _w, int _h, dialog *_dlg = NULL)
: mouse_control(_x, _y, _w, _h, _dlg)
{
}

/* control_shortkey */

bool control_shortkey::press()
{
	if(_shortkeys_disabled) return false;
		else return key[_key];
}

/* dialog */

dialog::dialog():
_active(false)
{

}

void dialog::update()
{
	if(_active) for(list<control*>::iterator i = controls.begin(); i != controls.end(); i++) (*i)->update();
}

void dialog::draw(BITMAP *bmp)
{
	if(_active) for(list<control*>::iterator i = controls.begin(); i != controls.end(); i++) (*i)->draw(bmp);
}

void dialog::refresh()
{
	for(list<control*>::iterator i = controls.begin(); i != controls.end(); i++)(*i)->refresh();
}

void dialog::activate()
{
   _active = true;
}

void dialog::deactivate()
{
   _active = false;
}

void dialog::add(control *control)
{
   controls.push_back(control);
   control->dlg = this;
}

void dialog::remove(control *control)
{
	if(control->dlg == this)
   {
	   control->dlg = NULL;
	   controls.remove(control);
   }
}

bool dialog::active()
{
	return(_active);
}

/* shortkey */

shortkey::shortkey(void(*_func)(), int __key, dialog *_dlg = NULL):
control(_dlg), func(_func), _shortkey(__key)
{}

void shortkey::update()
{
	if(!disabled())
	{
		if(_shortkey.press() && !getflag(PRESSED))
      {
      	setflag(PRESSED);
  			if (func != NULL) func();
      }

		else

		if (getflag(PRESSED) && !_shortkey.press())
      {
      	unsetflag(PRESSED);
      }
	}
}

// button


    void(*callback)(button *b);
    appearance *a;
    char* text;
    
button::button(int _x, int _y, int _drawx, int _drawy, int _w, int _h, char* _text, appearance *_a, dialog *_dlg = NULL):
mouse_control(_x, _y, _drawx, _drawy, _w, _h, _dlg),
callback(NULL),
a(_a),
text(_text)
{
}

button::button(int _x, int _y, int _w, int _h, char* _text, appearance *_a, dialog *_dlg = NULL):
mouse_control(_x, _y, _w, _h, _dlg),
callback(NULL),
a(_a),
text(_text)
{
}

void button::update()
{
	if (!getflag(DISABLED))
	{
		if(press_check()) take_focus();
		if(release_check()) if(callback != NULL) callback(this);
		mouse_over_check();
   	lose_mouse_over_check();
	}
}

void button::draw(BITMAP *bmp)
{
	bool d = false;

	if (getflag(DRAW))
	{
		unsetflag(DRAW);

		if (getflag(DISABLED))
		{
	   	rounded_box(bmp, drawx, drawy, drawx2, drawy2, a->dc1, a->dc2);
     		_textout(bmp, a->f, text, drawx, drawy, w, h, a->dfontc);
         d = true;
  		}

		if (getflag(MOUSEOVER))
		{
	   	rounded_box(bmp, drawx, drawy, drawx2, drawy2, a->mc1, a->mc2);
     		_textout(bmp, a->f, text, drawx, drawy, w, h, a->mfontc);
         d = true;
  		}


		if (getflag(PRESSED))
		{
	   	rounded_box(bmp, drawx, drawy, drawx2, drawy2, a->ptc1, a->ptc2);
     		_textout(bmp, a->f, text, drawx, drawy, w, h, a->ptfontc);
         d = true;
  		}

		if(d == false)
		{
	   	rounded_box(bmp, drawx, drawy, drawx2, drawy2, a->c1, a->c2);
     		_textout(bmp, a->f, text, drawx, drawy, w, h, a->fontc);

 		}
	}
}

/* static textbox */

static_textbox::static_textbox(int _x, int _y, int _w, int _h, char* _text, appearance *_a, dialog *_dlg = 0)
: static_control(_x, _y, _w, _h, _dlg),
text(_text),
a(_a)
{
}

void static_textbox::draw(BITMAP *bmp)
{
	if(getflag(DRAW))
   {
   	unsetflag(DRAW);

   	if(disabled())
      {
	   	rounded_box(bmp, drawx, drawy, drawx2, drawy2, a->dborderc, a->dc2);
     		_textout(bmp, a->f, text, drawx, drawy, w, h, a->dfontc);
      }

      else
      {
         rounded_box(bmp, drawx, drawy, drawx2, drawy2, a->borderc, a->c2);
			_textout(bmp, a->f, text, drawx, drawy, w, h, a->fontc);
      }
   }
}

/* static box */

static_box::static_box(int _x, int _y, int _w, int _h, appearance *_a, dialog *_dlg = 0)
: static_control(_x, _y, _w, _h, _dlg),
a(_a)
{
}

void static_box::draw(BITMAP *bmp)
{
	if(getflag(DRAW))
	{
   	unsetflag(DRAW);
		rounded_box(bmp, drawx, drawy, drawx2, drawy2, a->borderc, a->c2);
	}
}

/* static text */

static_text::static_text(int _x, int _y, char* _text, appearance *_a, dialog *_dlg = 0)
: static_control(_x, _y, 0, 0, _dlg),
text(_text),
a(_a)
{
}

void static_text::draw(BITMAP *bmp)
{
	if(getflag(DRAW))
	{
   	unsetflag(DRAW);
		textout(bmp, a->f, text, x, y, a->fontc);
	}
}

/* checkbox */

checkbox::checkbox(int _x, int _y, int _drawx, int _drawy, appearance *_a, bool _toggled, dialog *_dlg):
toggle_control(_x, _y, _drawx, _drawy, 25, 25, _dlg), a(_a)
{
   untoggle();
	if(_toggled) toggle();
}

checkbox::checkbox(int _x, int _y, appearance *_a, bool _toggled, dialog *_dlg):
toggle_control(_x, _y, 25, 25, _dlg), a(_a)
{
   untoggle();
	if(_toggled) toggle();
}

void checkbox::draw(BITMAP *bmp)
{
	if(getflag(DRAW))
   {
   	unsetflag(DRAW);
      rect(bmp, drawx, drawy, drawx2, drawy2, a->c1);
      rectfill(bmp, drawx+1, drawy+1, drawx2-1, drawy2-1, a->c2);
      if(toggled()) draw_checkmark(bmp, drawx, drawy, a->ptfontc);
   }
}

void checkbox::update()
{
	if(press_check())
   {
   	if(toggled()) untoggle();
      	else toggle();
	}
   release_check();
}

void checkbox::draw_checkmark(BITMAP *bmp, int x, int y, int col)
{
	do_line(bmp,x+4,y+5,x+7,y+20, col, put4pixel);
	do_line(bmp,x+7,y+20,x+20,y+4, col, put4pixel);
}

/* slider base class */

slider::slider(int _x, int _y, int _drawx, int _drawy, int _w, int _h, appearance *_a, int _minval, int _maxval, int __value, dialog *_dlg = NULL):
mouse_control(_x, _y, _drawx, _drawy, _w, _h, _dlg),
a(_a),
maxval(_maxval),
minval(_minval),
value(_minval)
{
	minptrsize = 10;
}

slider::slider(int _x, int _y, int _w, int _h, appearance *_a, int _minval, int _maxval, int __value, dialog *_dlg = NULL):
mouse_control(_x, _y, _w, _h, _dlg),
a(_a),
maxval(_maxval),
minval(_minval),
value(_minval)
{
	minptrsize = 10;
}

int slider::get_value()
{
	return value;
}

void slider::set_value(int _value)
{
	if (_value <= maxval && _value >= minval) value = _value;
}

void slider::inc(int n)
{
	set_value(value + n);
}

void slider::dec(int n)
{
	set_value(value - n);
}

void slider::change_value_range(int newmin, int newmax)
{
	int tmp = value;
	maxval = newmax;
   minval = newmin;
   value = minval;
   set_value(tmp);
   calc_ptr_size();
	refresh();
}

void slider::inc_value_range(int amount = 1)
{
	change_value_range(minval, maxval+amount);
}

void slider::dec_value_range(int amount = 1)
{
	change_value_range(minval, maxval-amount);
}

/* horizontal slider */

hslider::hslider(int _x, int _y, int _drawx, int _drawy, int _w, int _h, appearance *_a, int _minval, int _maxval, int _value, dialog *_dlg = NULL):
slider(_x, _y, _drawx, _drawy, _w, _h, _a, _minval, _maxval, _value, _dlg),
lbutton(_x, _y, _drawx, _drawy, _h, _h, "<", _a, 0),
rbutton(_x+(_w-_h), _y, _drawx+(_w-_h), _drawy, _h, _h, ">", _a, 0)
{
	set_value(_value);
   calc_ptr_size();
}

hslider::hslider(int _x, int _y, int _w, int _h, appearance *_a, int _minval, int _maxval, int _value, dialog *_dlg = NULL):
slider(_x, _y, _w, _h, _a, _minval, _maxval, _value, _dlg),
lbutton(_x, _y, _h, _h, "<", _a, 0),
rbutton(_x+(_w-_h), _y, _h, _h, ">", _a, 0)
{
	set_value(_value);
   calc_ptr_size();
}

void hslider::draw(BITMAP *bmp)
{
 	lbutton.draw(bmp);
   rbutton.draw(bmp);

	if (getflag(DRAW))
   {
      rectfill(bmp, drawx+h, drawy, drawx+w-h-1, drawy+h-1, a->c2);
      int showerx = (drawx+h+1) + int(pixpv * (value-minval));
      //_rect(bmp, showerx, drawy, showerx+ptrsize, drawy+h-1, a->c1, a->c2, a->c3);

      line(bmp, drawx+h, drawy+h/2, drawx2-h, drawy2-h/2, makecol(255,255,255));
      rectfill(bmp, drawx+h, drawy, drawx2-h, drawy2, a->c2);
      rectfill(bmp, showerx, drawy, showerx+ptrsize, drawy+h-1, a->c1);
	   textprintf_centre (bmp, a->f, drawx+ w/2, drawy+ h/2 - text_height(a->f)/2, a->ptfontc, "%d", value);
   	unsetflag(DRAW);
   }
}

void hslider::update()
{
	if(!getflag(DISABLED))
   {
		lbutton.update();
	   rbutton.update();

      if(lbutton.pressed())
      {
      	dec(1);
	      refresh();
         take_focus();
      }

      if(rbutton.pressed())
      {
      	inc(1);
	      refresh();
         take_focus();
      }

			if (mouse_x > x+h && mouse_x < x+w-h && mouse_y >=y && mouse_y <=y+h && mouse_b & 1)
      	{
      		set_value(minval + (mouse_x-x-h)/pixpv);
            refresh();
	         take_focus();
         }

      if(has_focus())
      {
			if(key[KEY_LEFT]) { dec(1); refresh(); }
			if(key[KEY_RIGHT]) { inc(1); refresh(); }
      }

   }
}

void hslider::refresh()
{
	setflag(DRAW);
	lbutton.refresh();
   rbutton.refresh();
}

void hslider::calc_ptr_size()
{
	float space = float(w-minptrsize)-float(h*2)-2;
	pixpv = space/float(abs(maxval-minval)+1);
	ptrsize = int(minptrsize+pixpv);
}

