#include <allegro.h>
#include <math.h>
#include <time.h>

const float PI = 3.1415926;

class sinusimg
{
   public:
    sinusimg(int _x, int _y, BITMAP* _image, int _amp, int _freq);   // constructor
    ~sinusimg();

    void update();
    void draw(BITMAP *dest);

   private:
    int x, y, w, h;               // positions and size
    int amp, freq;                // amplitude, frequenty
    fix *hsintable, *vsintable;   // horizontal and vertical sinus table
    BITMAP *image;                // pointer to image

    void init_hsintable();        // initialise vertical sinus table
    void init_vsintable();        // initialise horizontal sinus table
};

sinusimg::sinusimg(int _x, int _y, BITMAP* _image, int _amp, int _freq)
{
   x = _x;
   y = _y;
   image = _image;
   w = image->w;
   h = image->h;
   amp = _amp;
   freq = _freq;

   hsintable = new fix[h];
   init_hsintable();

   vsintable = new fix[w];
   init_vsintable();
}

sinusimg::~sinusimg()
{
   delete[] hsintable;
   delete[] vsintable;
}

void sinusimg::init_hsintable()
{
   for (int c=0; c<h; c++) hsintable[c] = sin(c*(2*PI/(h/freq))) * amp*2;
}

void sinusimg::init_vsintable()
{
   for (int c=0; c<w; c++) vsintable[c] = sin(c*(2*PI/(w/freq))) * amp - 10;
}

void sinusimg::update()
{
   // rotate vertical sinus table
   fix temp = vsintable[w-1];
   for (int c=w-2; c>=0; c--) vsintable[c+1] = vsintable[c];
   vsintable[0] = temp;

   // rotate horizontal sinus table
   temp = hsintable[h-1];
   for (int c=h-2; c>=0; c--) hsintable[c+1] = hsintable[c];
   hsintable[0] = temp;
}

void sinusimg::draw(BITMAP* dest)  // draw on destination bitmap
{
   for (int xc=0; xc<w; xc++)
      for (int yc=0; yc<h; yc++)
      {
      /*16 bpp*/ ((short *)dest->line[y + vsintable[xc] + yc])[x + hsintable[yc] + xc] = ((short*)image->line[yc])[xc];      
      // /*32 bpp*/ ((long *)dest->line[y + vsintable[xc] + yc])[x + hsintable[yc] + xc] = ((long*)image->line[yc])[xc];
      }
}

volatile int speed_counter = 0;

void inc_speed_counter()
{
   speed_counter++;
} END_OF_FUNCTION(inc_speed_counter);

// fps counter

volatile int fps = 0;      // frames per second
volatile int fpscount = 0; // frames per second-count variable

void fpscounter()    // frames per second counter
{
   fps = fpscount;   // fps = counted fps
   fpscount = 0;     // reset counter   
} END_OF_FUNCTION(fpscounter);

int main()
{
   srand(time(NULL));

   allegro_init();
   install_keyboard();
   install_timer();

   set_color_depth(16);

   if (set_gfx_mode(GFX_AUTODETECT, 640, 480, 640, 480) < 0)
   {
      allegro_message("Error setting video mode %s", allegro_error);
    
      exit(1);
   }

   DATAFILE* ydat = load_datafile("yinyang.dat");
   if (ydat == NULL)
   {
      allegro_message("unable to load datafile");
      return 1;
   }

   LOCK_VARIABLE(fps);
   LOCK_VARIABLE(fpscount);
   LOCK_FUNCTION(fpscounter);
	install_int_ex(fpscounter, SECS_TO_TIMER(1));
	
   sinusimg yinyang(SCREEN_W/2-100, SCREEN_H/2-100, (BITMAP*)ydat[0].dat, 70, 1);

   BITMAP *buf = create_bitmap(SCREEN_W,SCREEN_H);
   clear_to_color(buf, makecol(0,0,0));

   LOCK_VARIABLE(speed_counter);
   LOCK_FUNCTION(inc_speed_counter);
   install_int_ex(inc_speed_counter, BPS_TO_TIMER(90));

   while (!key[KEY_ESC])
   {
      while (speed_counter > 0)
      {
       	yinyang.update();
         speed_counter--;
      }
      
      acquire_bitmap(buf);
      yinyang.draw(buf);
      
//      if(key[KEY_TAB]) save_bmp("yinyang_shot.bmp", buf, NULL);
      blit (buf, screen, 70, 55, 70, 50, SCREEN_W-140, SCREEN_H-90);
      clear_to_color(buf,makecol(0,0,0));
      release_bitmap(buf);
//      textprintf(screen, font, SCREEN_W-100, 10, makecol(255,255,255), "fps: %d", fps);     
                      
      fpscount++;	// count the frames      
   }

   destroy_bitmap(buf);
   
   unload_datafile(ydat);
   
   return 0;

} END_OF_MAIN();
