#include <allegro.h>
#include <math.h>
#include <time.h>

volatile int speed_counter = 0;

void inc_speed_counter()
{
	speed_counter++;
}
END_OF_FUNCTION(inc_speed_counter);

/* fps counter */

volatile int fps = 0;			/* frames per second */
volatile int fpscount = 0;		/* frames per second-count variable */

void fpscounter()				/* frames per second counter */
{
	fps = fpscount;			/* fps = counted fps */
	fpscount = 0;				/* reset counter */
} END_OF_FUNCTION(fpscounter);

int main()
{
	int x, y, w, h;			/* Positions and size */
	int amp, freq;				/* Amplitude, frequenty */
	fixed *hsintable;			/* Horizontal sinus table */
	fixed *vsintable;			/* Vertical sinus table */

	BITMAP *image;				/* Pointer to the image */
	BITMAP *buffer;			/* Double buffering */
	int c, xc, yc;				/* Temporary loop counters */
	fixed temp;					/* Temporary helper */
	PALETTE pal;				/* Palette from image */

	srand(time(NULL));

	allegro_init();
	install_keyboard();
	install_timer();
	
	set_color_depth(8);

	if (set_gfx_mode(GFX_DIRECTX, 640, 480, 0, 0) < 0) {
		allegro_message("Error setting video mode: %s.", allegro_error);
		allegro_exit();
		return 1;
	}

	LOCK_VARIABLE(fps);
	LOCK_VARIABLE(fpscount);
	LOCK_FUNCTION(fpscounter);
	install_int_ex(fpscounter, SECS_TO_TIMER(1));

	/* INITIALIZATION */
	image = load_bitmap("yang.bmp", pal);
	if (image == NULL) {
		allegro_message("Unable to load bitmap file.");
		allegro_exit();
		return 1;
	}

	x = SCREEN_W/2 - image->w/2;
	y = SCREEN_H/2 - image->h/2;
	w = image->w;
	h = image->h;
	amp = 75;
	freq = 1;
	hsintable = malloc(sizeof(fixed)*h);
	vsintable = malloc(sizeof(fixed)*w);
	for (c=0; c<h; c++) hsintable[c] = sin(c*(2*AL_PI/(h/freq))) * amp * 2;
	for (c=0; c<w; c++) vsintable[c] = sin(c*(2*AL_PI/(w/freq))) * amp - 10;

	set_palette(pal);
	clear_to_color(screen, makecol(0,0,0));

	buffer = create_bitmap(SCREEN_W, SCREEN_H);
	if(buffer == NULL) {
		allegro_message("Error. No memory???");
		allegro_exit();
		return 1;
	}

	LOCK_VARIABLE(speed_counter);
	LOCK_FUNCTION(inc_speed_counter);
	install_int_ex(inc_speed_counter, BPS_TO_TIMER(140));

	while (!key[KEY_ESC]) {
		while (speed_counter > 0) {
			/* LOGICAL PART */

			/* rotate vertical sinus table */
			temp = vsintable[w-1];
			for (c=w-2; c>=0; c--) vsintable[c+1] = vsintable[c];
			vsintable[0] = temp;

			/* rotate horizontal sinus table */
			temp = hsintable[h-1];
			for (c=h-2; c>=0; c--) hsintable[c+1] = hsintable[c];
			hsintable[0] = temp;
			
			speed_counter--;
		}

		/* DRAW */

		acquire_bitmap(buffer);

		clear_to_color(buffer, makecol(0,0,0));

		for (xc=0; xc<w; xc++) {
			for (yc=0; yc<h; yc++) {
				_putpixel(buffer, x+hsintable[yc]+xc, y+vsintable[xc]+yc, _getpixel(image, xc, yc));
			}
		}

		release_bitmap(buffer);

		blit(buffer, screen, 70, 55, 70, 50, SCREEN_W-140, SCREEN_H-90);

		/*	textprintf(screen, font, 10, 10, makecol(255,255,255), " fps: %d ", fps); 
		if(key[KEY_TAB]) save_bmp("yinyang_shot.bmp", buffer, pal); */

		fpscount++;	/* count frames */
	}

	destroy_bitmap(buffer);
	destroy_bitmap(image);

	free(hsintable);
	free(vsintable);

	allegro_exit();

	return 0;

} END_OF_MAIN();
