#include "TileDef.h"

TileDef::TileDef(const char *name, Image *image, Rectangle hitBox, bool comeFromBelow, bool iceCovered, bool openTop, bool openLeft, bool openRight): Resource(name)
{
	Init(image,hitBox,comeFromBelow,iceCovered,openTop,openLeft,openRight);
}

TileDef::TileDef(const char *name, std::string imageName, Rectangle hitBox, bool comeFromBelow, bool iceCovered, bool openTop, bool openLeft, bool openRight): Resource(name){
	Init((Image*)ResourceManager::inst()->GetResource(imageName), hitBox, comeFromBelow, iceCovered,openTop,openLeft,openRight);
}

TileDef::~TileDef(void)
{
}

void TileDef::Init(Image *image, Rectangle hitBox, bool comeFromBelow, bool iceCovered, bool openTop, bool openLeft, bool openRight){
	this->image = image;
	this->animDef = 0;
	this->hitBox = hitBox;
	this->comeFromBelow = comeFromBelow;
	this->iceCovered = iceCovered;
	this->openLeft = openLeft;
	this->openRight = openRight;
	this->openTop = openTop;
}

bool TileDef::HasOpenTop(){
	return openTop;
}

bool TileDef::HasOpenLeft(){
	return openLeft;
}

bool TileDef::HasOpenRight(){
	return openRight;
}

