#include "Tile.h"

Tile::Tile(){
	this->tileDef = 0;
}

Tile::Tile(std::string name, TileDef *tileDef)
{
	this->tileDef= tileDef;
	this->name = name;
	if(this->tileDef){
		if(this->tileDef->GetIceCovered()){
			frictionValue = 0.00006f;
		}
		else{
			frictionValue = 0.0006f;
		}
	}
}

Tile::~Tile(void)
{
}


void Tile::SetTileDef(TileDef *tileDef){
	this->tileDef= tileDef;
}

void Tile::Draw(BITMAP *dest, int x, int y){
	if(tileDef && tileDef->GetImage()){
		tileDef->GetImage()->Draw(dest,x,y);
	}
}

void Tile::Update(int msecPassed){
}

bool Tile::IsPositionInHitBox(int x, int y){
	if( tileDef ){
		Rectangle hitBox = tileDef->GetHitBox();
		if(x >= hitBox.x && x <= hitBox.x+hitBox.w &&
			y >= hitBox.y && y <= hitBox.y+hitBox.h ){
				return true;
		}
	}
	return false;
}

void Tile::Cleanup(bool openTop, bool openLeft, bool openRight){

}


