#pragma once

#include <string>
#include <map>
#include <iostream>
#include <fstream>

#include "Log.h"
#include "Resource.h"
#include "Image.h"
#include "Song.h"
#include "Font.h"

class ResourceManager
{
private:
	ResourceManager(void);

	std::map<std::string , Resource*> resources;
	

public:
	~ResourceManager(void);

	static ResourceManager* inst();
	void Destroy();

	void AddResource(Resource* res);
	Resource* GetResource(std::string name);

	void LoadResourceFile(char *filename);
	
	static void TrimSpaces( std::string& str);
};
