#include "ResourceManager.h"

#include "Image.h"
#include "Song.h"

using namespace std;

ResourceManager::ResourceManager(void)
{
}

ResourceManager::~ResourceManager(void)
{
	Log::inst()->logLine("Destroying the Resource Manager",1);
	
	map<std::string , Resource*>::iterator it;
	for(it = resources.begin() ; it!=resources.end(); it++){
		Resource *toDelete = (*it).second;
		delete toDelete;
		
	}
	resources.clear();
	Log::inst()->logLine("Done destroying the Resource Manager",-1);
}

ResourceManager* ResourceManager::inst(){
	static ResourceManager instance;
	return &instance;
}


void ResourceManager::AddResource(Resource* res){
	if(res && res->GetName()){
		if(resources.count(*res->GetName())==0){
			resources[*res->GetName()] = res;
		}
	}
}

Resource* ResourceManager::GetResource(std::string name){
	if(resources.count(name)>0){
		return resources[name];
	}
	else{
		Log::inst()->logLine("[RESOURCE MANAGER] Error getting resource with name: "+name);
		return 0;
	}
}

void ResourceManager::TrimSpaces(std::string& theStr)  
{  
    // Trim Both leading and trailing spaces  
	size_t startpos = theStr.find_first_not_of(" \t\r"); // Find the first character position after excluding leading blank spaces  
    size_t endpos = theStr.find_last_not_of(" \t\r"); // Find the first character position from reverse af  
  
    // if all spaces or empty return an empty string  
    if(( string::npos == startpos ) || ( string::npos == endpos))  
    {  
        theStr = "";  
    }  
    else  
        theStr = theStr.substr( startpos, endpos-startpos+1 );  
  
    /* 
    // Code for  Trim Leading Spaces only 
    size_t startpos = str.find_first_not_of(” \t”); // Find the first character position after excluding leading blank spaces 
    if( string::npos != startpos ) 
        str = str.substr( startpos ); 
    */  
  
    /* 
    // Code for Trim trailing Spaces only 
    size_t endpos = str.find_last_not_of(” \t”); // Find the first character position from reverse af 
    if( string::npos != endpos ) 
        str = str.substr( 0, endpos+1 ); 
    */  
} 

void ResourceManager::LoadResourceFile(char *filename){
	ifstream file;
	file.open(filename,ios::in);

	if(file.is_open()){
		string content[3];	//type, name, filename
		string oneLine;
		
		while(!file.eof()){
			getline(file,oneLine);
			//Log::inst()->logLine(oneLine);
			unsigned int start=0;
			unsigned int counter=0;
			while(start<oneLine.length()){
				unsigned int p = oneLine.find_first_of ( '\t', start);
				
				if(p==oneLine.npos)
					p=oneLine.length();
				
				content[counter] = oneLine.substr(start,p-start);
				TrimSpaces(content[counter]);

				start = p+1;
				counter++;
				if(counter>=3)
					break;
			}
			
			if(content[0].compare("IMAGE")==0){
				Image* img = new Image(content[1].c_str(),content[2].c_str());
				if(img){
					this->AddResource(img);
				}
			}
			else if(content[0].compare("SONG")==0){
				Song* song = new Song(content[1].c_str(),content[2].c_str());
				if(song){
					this->AddResource(song);
				}
			}
			else if(content[0].compare("FONT")==0){
				Font* font = new Font(content[1].c_str(),content[2].c_str());
				if(font){
					this->AddResource(font);
				}
			}
		}
	}
	else{
		Log::inst()->logLine("Error opening resource file: ["+string(filename)+"]");
	}
}