#pragma once
#include <allegro.h>
#include "Constants.h"
#include "Character.h"
#include "Map.h"
#include "Pickup.h"
#include "EnimDef.h"
#include "Enemy.h"


class Player :
	public Character
{
private:
	int originalX, originalY, originalDir;
	int ammo;
	ProjectileList *projList;
	int health;
	int maxHealth;
	int invincibleCounter;
	bool dying, dead;
	int flashCounter;


	void DrawPowerBar(BITMAP *dest, int x, int y);

	FONT *hudFont, *dyingMessage1Font, *dyingMessage2Font;
	Image *hudHeartImage, *hudPresentImage;

	int elfsLeft;
	bool startNextLevel;
	int curLevelNum;

public:
	Player(Rectangle hitBox);
	~Player(void);

	void Draw(BITMAP *dest, int screenx, int screeny);
	void Update(int msecPassed,Map *map);
	void Reset();

	void Jump(int msecPassed);
	void WalkLeft();
	void WalkRight();

	void DrawHUD(BITMAP *dest);

	void PickUp(Pickup *pickup);

	void HitByProj(Projectile *proj, int msecPassed);

	void SetAmmo(int ammo) { this->ammo = ammo; }
	bool HasAmmo() { return ammo>0; }
	void SetPosition(float x, float y, int dir=-1);

	void StartThrowingProjectile(int msecPassed, ProjectileList *projList);
	void ThrowProjectile(int msecPassed, ProjectileList *projList);

	void ModifyAnimation();

	void ReactToAnimationsFinishing(int msecPassed);
	int ThrowLocationX() { return (dir==Character::FACING_LEFT?6:37); }
	int ThrowLocationY() { return 30; }

	void HitByEnemy(Enemy *enemy, int msecPassed);

	void StartDying();
	void Die(Map *map);

	void StartLevel(Map *map, int levelNum);
	bool ShouldStartNextLevel();
};
