#include "MapDecoration.h"

MapDecoration::MapDecoration(MapDecorationDef *def) : Actor(def->hitBox,def->moveable)
{
	this->def = def;
	this->moveable = def->moveable;
	this->hitBox = def->hitBox;
	this->AddAnimation(def->animDef);
}

MapDecoration::MapDecoration(std::ifstream *file) : Actor(MakeRectangle(0,0,0,0),false) {
	LoadFromMapFile(file);
	this->moveable = def->moveable;
	this->hitBox = def->hitBox;
	this->AddAnimation(def->animDef);
}

MapDecoration::~MapDecoration(void)
{
}

void MapDecoration::SaveToMapFile(std::ofstream *file){
	(*file) << this->def->GetName()->c_str() << '\t';
	(*file) << this->x << '\t';
	(*file) << this->y << '\t';
}

void MapDecoration::LoadFromMapFile(std::ifstream *file){
	int tx,ty;
	MapDecorationDef *def = 0;
	std::string defName;

	(*file) >> defName;
	(*file) >> tx;
	(*file) >> ty;

	def = (MapDecorationDef*)ResourceManager::inst()->GetResource(defName);
	if(def){
		this->def = def;
	}
	SetPosition(tx,ty);
}