#pragma once

#include <allegro.h>
#include <string>
#include <iostream>
#include <fstream>
#include <vector>
#include <list>

#include "Constants.h"
#include "Tile.h"
#include "TileSet.h"
#include "MapDecoration.h"
#include "Pickup.h"
#include "ProjectileList.h"
#include "EnimDef.h"

class Player;
class Enemy;

struct Snowflake{
	float x, y;
	float vx, vy;
};

class Map
{
private:
	TileSet *tileSet;
	Tile *tiles[MAX_MAP_WIDTH][MAX_MAP_HEIGHT];
	std::string filename;

	std::list<MapDecoration*> decorations;
	std::list<Pickup*> pickupList;
	std::list<Enemy*> enemyList;

	int hillPointsY[NUM_HILL_POINTS];
	int hill2PointsY[NUM_HILL_POINTS];

	Snowflake snowflakes[MAX_SNOW_FLAKES];

	int startingAmmo;
	ProjectileList *projList;


public:
	Map(void);
	~Map(void);
	void DeleteAll(void);

	void Draw(BITMAP *dest, int screenx, int screeny);
	void DrawForeground(BITMAP *dest, int screenx, int screeny);
	void Update(int msecPassed);
	void ClearForces();

	void SetTileSet(TileSet * ts);
	TileSet* GetTileSet(){ return tileSet;}
	void SetTile(int x, int y, std::string name);
	void RemoveTile(int x, int y);
	void CleanUp();
	void Erase();

	Tile* GetTileAt(int x, int y);

	void Save();
	void Load(std::string filename);

	MapDecoration* AddDecoration(MapDecorationDef *def, int x, int y);
	void AddDecoration(MapDecoration *decoration);

	void AddPickup(Pickup *pickup, float x, float y);
	void CheckCollsisionWithPickups(Player *p, int msecPassed);

	void AddEnemy(EnimDef *enemy, int startingDir, float x, float y);
	void AddEnemy(Enemy *enemy);
	void CheckEnemyCollisionWithProjectiles(ProjectileList* projList, int msecPassed);
	Enemy* CheckCollisionWithEnemy(Actor* actor, int msecPassed);

	void ResetEnemies();
	void ResetPickups();
	void ResetProjectiles();

	Enemy* CheckCollisionWithEnemy(int x, int y, int msecPassed);
	MapDecoration* CheckCollisionWithDecoration(int x, int y, int msecPassed);
	Actor* CheckCollisionWithActor(int x, int y, int msecPassed);

	int CountLivingElfs();

	void SpawnSnowflake(int i, int screenx, int screeny);

	int GetStartingAmmo() { return startingAmmo; }
};
