#include "Map.h"
#include "Player.h"
#include "Enemy.h"

using namespace std;

Map::Map(void)
{
	for(int y=0 ; y<MAX_MAP_HEIGHT ; y++){
		for(int x=0 ; x<MAX_MAP_WIDTH ; x++)
		{
			tiles[x][y]=0;
		}
	}

	hillPointsY[0] = 200;
	for(int i=1 ; i<NUM_HILL_POINTS ; i++){
		hillPointsY[i] = hillPointsY[i-1] + rand()%100 - 50;
	}

	hill2PointsY[0] = 300;
	for(int i=1 ; i<NUM_HILL_POINTS ; i++){
		hill2PointsY[i] = hill2PointsY[i-1] + rand()%50 - 25;
	}

	for(int i=0 ; i<MAX_SNOW_FLAKES ; i++){
		snowflakes[i].x = (rand()%(Constants::BACKGROUND_WIDTH*7)) - Constants::BACKGROUND_WIDTH*3;
		snowflakes[i].y = (rand()%1200);

		snowflakes[i].vx=0;
		snowflakes[i].vy=0.02f + 0.03f*(((float)(rand()%100))/100) ;
		//SpawnSnowflake(i,0,0);
	}

	startingAmmo = 5;
	projList = 0;
}

Map::~Map(void)
{
	DeleteAll();
}

void Map::DeleteAll(void){
	Log::inst()->logLine("Destroying the Map",1);
	
	Log::inst()->logLine("Clearing the Decorations vector",1);
	decorations.clear();
	Log::inst()->logLine("Done clearing the Decorations vector",-1);

	Log::inst()->logLine("Clearing the Pickup list",1);
	list<Pickup*>::iterator it;
	for(it = pickupList.begin() ; it!=pickupList.end(); it++){
		Pickup *toDelete = (*it);
		delete toDelete;
	}
	pickupList.clear();
	Log::inst()->logLine("Done clearing the Pickup list",-1);

	Log::inst()->logLine("Clearing the Enemy list",1);
	list<Enemy*>::iterator enemyIter;
	for(enemyIter = enemyList.begin() ; enemyIter!=enemyList.end(); enemyIter++){
		Enemy *toDelete = (*enemyIter);
		delete toDelete;
	}
	enemyList.clear();
	Log::inst()->logLine("Done clearing the Enemy list",-1);

	Log::inst()->logLine("Clearing the Decoration list",1);
	list<MapDecoration*>::iterator decIter;
	for(decIter = decorations.begin() ; decIter!=decorations.end(); decIter++){
		MapDecoration *toDelete = (*decIter);
		delete toDelete;
	}
	decorations.clear();
	Log::inst()->logLine("Done clearing the Decoration list",-1);

	Log::inst()->logLine("Done destroying the Map",-1);
}



void Map::Draw(BITMAP *dest, int screenx, int screeny)
{
	//int tilesToDrawX = Constants::BACKGROUND_WIDTH / TILE_WIDTH;
	//int leftmostTile = screenx % TILE_WIDTH - 1;
	//int topmostTile = screenh % TILE_WIDTH -1;
	int leftmostTile = (int)(screenx / TILE_WIDTH) - 1;
	int topmostTile = (int)(screeny / TILE_HEIGHT) - 1;

	int tilesToDrawX = (int)(Constants::BACKGROUND_WIDTH / TILE_WIDTH) + 2;
	int tilesToDrawY = (int)(Constants::BACKGROUND_HEIGHT / TILE_HEIGHT) + 3;


	int hill1points[8], hill2points[8];
	for(int i=(int)((screenx/3)/50) ; i<NUM_HILL_POINTS-1 && i<(int)(((screenx/3)+Constants::BACKGROUND_WIDTH)/50)+1 ; i++){
		hill1points[0] = i*50 - screenx/3;
		hill1points[1] = 1000;

		hill1points[2] = i*50 - screenx/3;
		hill1points[3] = hillPointsY[i] - screeny/4;

		hill1points[4] = (i+1)*50 - screenx/3;
		hill1points[5] = hillPointsY[i+1] - screeny/4;

		hill1points[6] = (i+1)*50 - screenx/3;
		hill1points[7] = 1000;
		polygon(dest,4,hill1points,makecol(151, 185, 219));
	}

	for(int i=(int)((screenx/1.5)/50) ; i<NUM_HILL_POINTS-1 && i<(int)(((screenx/1.5)+Constants::BACKGROUND_WIDTH)/50)+1 ; i++){
		hill2points[0] = i*50 - screenx/1.5;
		hill2points[1] = 1000;

		hill2points[2] = i*50 - screenx/1.5;
		hill2points[3] = hill2PointsY[i] - screeny/3;

		hill2points[4] = (i+1)*50 - screenx/1.5;
		hill2points[5] = hill2PointsY[i+1] - screeny/3;

		hill2points[6] = (i+1)*50 - screenx/1.5;
		hill2points[7] = 1000;
		polygon(dest,4,hill2points,makecol(141, 175, 209));
	}

	list<MapDecoration*>::iterator iter; 
	for(iter = decorations.begin(); iter!=decorations.end() ; iter++){
		if((*iter)){
			if(!(*iter)->IsForeground())
				(*iter)->Draw(dest,screenx,screeny);
		}
	}

	for(int y=topmostTile ; y<topmostTile+tilesToDrawY ; y++){
		for(int x=leftmostTile ; x<leftmostTile+tilesToDrawX ; x++){
			if(x>=0 && y>=0 && x<MAX_MAP_WIDTH && y<MAX_MAP_HEIGHT){
				if(tiles[x][y]!=0){
					tiles[x][y]->Draw(dest,x*TILE_WIDTH - screenx, y*TILE_HEIGHT - screeny);
				}
			}
		}
	}



	list<Enemy*>::iterator enemyIter;
	for(enemyIter = enemyList.begin(); enemyIter!=enemyList.end() ; enemyIter++){
		if((*enemyIter)){
			(*enemyIter)->Draw(dest,screenx,screeny);
		}
	}

	list<Pickup*>::iterator it;
	for(it = pickupList.begin(); it!=pickupList.end() ; it++){
		if((*it)){
			(*it)->Draw(dest,screenx,screeny);
		}
	}


}

void Map::DrawForeground(BITMAP *dest, int screenx, int screeny){
	list<MapDecoration*>::iterator iter; 
	for(iter = decorations.begin(); iter!=decorations.end() ; iter++){
		if((*iter)){
			if((*iter)->IsForeground())
				(*iter)->Draw(dest,screenx,screeny);
		}
	}

	for(int i=0 ; i<MAX_SNOW_FLAKES ; i++){
		if(snowflakes[i].y > 1200){
			SpawnSnowflake(i,screenx,screeny);
		}
		circlefill(dest, snowflakes[i].x - screenx,snowflakes[i].y - screeny,2,makecol(240,240,240));
	}
}

void Map::Erase(){
	DeleteAll();
	for(int y=0 ; y<MAX_MAP_HEIGHT ; y++){
		for(int x=0 ; x<MAX_MAP_WIDTH ; x++)
		{
			tiles[x][y]=0;
		}
	}
}

void Map::ClearForces(){
	list<Enemy*>::iterator enemyIter;
	for(enemyIter = enemyList.begin(); enemyIter!=enemyList.end() ; enemyIter++){
		if((*enemyIter)){
			(*enemyIter)->ClearForces();
		}
	}

	list<MapDecoration*>::iterator decIter;
	for(decIter = decorations.begin(); decIter!=decorations.end() ; decIter++){
		if((*decIter)){
			(*decIter)->ClearForces();
		}
	}
}

void Map::Update(int msecPassed)
{


	list<Enemy*>::iterator enemyIter;
	for(enemyIter = enemyList.begin(); enemyIter!=enemyList.end() ; ){
		Enemy *e = *enemyIter;
		enemyIter++;
		if(e){
			e->ApplyForce(0,GRAVITY);
			e->Update(msecPassed,this);
			/*if(e->IsDead()){
				delete e;
				enemyList.remove(e);
			}*/
		}
	}

	list<MapDecoration*>::iterator iter; 
	for(iter = decorations.begin(); iter!=decorations.end() ;) {
		MapDecoration *dec = *iter;
		iter++;
		if(dec){

			if(dec->GetX()>=0 && dec->GetX() < MAX_MAP_WIDTH*TILE_WIDTH &&
				dec->GetY()>=0 && dec->GetY() < MAX_MAP_HEIGHT*TILE_HEIGHT){
				if(dec->IsMoveable())
					dec->ApplyForce(0,GRAVITY);
				dec->Update(msecPassed,this);
			}
			else{
				delete dec;
				decorations.remove(dec);
			}
		}
	}

	list<Pickup*>::iterator it;
	for(it = pickupList.begin(); it!=pickupList.end() ; it++){
		if((*it)){
			(*it)->Update(msecPassed,this);
		}
	}

	
	float velXAdj = 0.05f  / ((float)msecPassed);
	for(int i=0 ; i<MAX_SNOW_FLAKES ; i++){
		snowflakes[i].y += snowflakes[i].vy*msecPassed;
		snowflakes[i].x += snowflakes[i].vx*msecPassed;

		snowflakes[i].vx+= ((((float)(rand()%100))/100)*velXAdj) - (velXAdj/2);
		if(snowflakes[i].vx > 0.01f)
			snowflakes[i].vx = 0.01f;
		else if (snowflakes[i].vx < -0.01f)
			snowflakes[i].vx = -0.01f;
	}
}

void Map::CheckEnemyCollisionWithProjectiles(ProjectileList* projList, int msecPassed){
	this->projList = projList;
	list<Enemy*>::iterator enemyIter;
	for(enemyIter = enemyList.begin(); enemyIter!=enemyList.end() ; enemyIter++){
		if((*enemyIter)){
			(*enemyIter)->CheckCollisionWithProjectiles(projList, msecPassed);
		}
	}
}

void Map::SetTileSet(TileSet * ts){
	tileSet = ts;
}

void Map::SetTile(int x, int y, std::string name){
	if(tileSet){
		if(x>=0 && y>=0 && x<MAX_MAP_WIDTH && y<MAX_MAP_HEIGHT){
			tiles[x][y] = tileSet->GetTile(name);
		}

	}
}

void Map::RemoveTile(int x, int y){
	tiles[x][y]=0;
}

Tile* Map::GetTileAt(int x, int y){
	int indexX = x/TILE_WIDTH;
	int indexY = y/TILE_HEIGHT;

	int offsetX = x%TILE_WIDTH;
	int offsetY = y%TILE_HEIGHT;

	if(indexX>=0 && indexY>=0 && indexX<MAX_MAP_WIDTH && indexY<MAX_MAP_HEIGHT){
		Tile *t = tiles[indexX][indexY];
		if(t){
			if(t->IsPositionInHitBox(offsetX,offsetY))
				return t;
		}
	}
	return 0;
}

void Map::CleanUp(){
	for(int y=0 ; y<MAX_MAP_HEIGHT ; y++){
		for(int x=0 ; x<MAX_MAP_WIDTH ; x++){



			Tile *t = tiles[x][y];
			Tile *pos8=0, *pos9=0, *pos6=0, *pos3=0, *pos2=0, *pos1=0, *pos4=0, *pos7=0;

			if(y-1>=0){
				if(x-1>=0)
					pos7 = tiles[x-1][y-1];
				pos8 = tiles[x][y-1];
				if(x+1<MAX_MAP_WIDTH)
					pos9 = tiles[x+1][y-1];
			}

			if(y>=0){	//this is always true, but I'm doing the check to make the formatting look better :)
				if(x-1>=0)
					pos4 = tiles[x-1][y];
				if(x+1<MAX_MAP_WIDTH)
					pos6 = tiles[x+1][y];
			}

			if(y+1<MAX_MAP_HEIGHT){
				if(x-1>=0)
					pos1 = tiles[x-1][y+1];
				pos2 = tiles[x][y+1];
				if(x+1<MAX_MAP_WIDTH)
					pos3 = tiles[x+1][y+1];
			}

			
			if(t){
				TileDef *td = t->GetTileDef();
				if(td){

					//for a normal tile
					if(td->GetComeFromBelow()==false && td->GetIceCovered()==false){
						//check to see if there is nothing above
						if(pos8==0){
							//this means there is no tile above this one, so I need to pick a tile with open top
							//now check to see if there is a tile to the left
							if(pos4==0){
								//this means there is no tile to the left of this one
								//t->Cleanup(true,true,false);
								tiles[x][y]=tileSet->GetTile("5");
							}
							else if(pos6==0){
								//this means there is no tile to the right of this one
								//t->Cleanup(true,false,true);
								tiles[x][y]=tileSet->GetTile("4");
							}
							else{	//this means that there are tiles on both sides
							

								//check to see if it is bordered by "come from below" tiles
								if(pos4->GetTileDef()->GetComeFromBelow()){
									tiles[x][y]=tileSet->GetTile("10");
								}
								else if(pos6->GetTileDef()->GetComeFromBelow()){
									tiles[x][y]=tileSet->GetTile("11");
								}

								//check to see if it is bordered by "ice" tiles
								else if(pos4->GetTileDef()->GetIceCovered()){
									tiles[x][y]=tileSet->GetTile("20");
								}
								else if(pos6->GetTileDef()->GetIceCovered()){
									tiles[x][y]=tileSet->GetTile("19");
								}

								/*else if(pos7!=0){
									//there is a tile to the top left of this one
									tiles[x][y]=tileSet->GetTile("13");
								}
								else if(pos9!=0){
									tiles[x][y]=tileSet->GetTile("12");
								}*/


								else{
									tiles[x][y]=tileSet->GetTile("2");
								}

								
							}

						}

						else if(pos4==0){
							//this means there is a tile above, but not to the left
							tiles[x][y]=tileSet->GetTile("7");
						}
						else if(pos6==0){
							//this means there is a tile above, but not to the right
							tiles[x][y]=tileSet->GetTile("6");
						}
						else{
							//this means that there is a tile above, and on both sides
							if(pos4!=0 && pos4->GetTileDef()->GetComeFromBelow())
								tiles[x][y]=tileSet->GetTile("8");
							else if(pos6!=0 && pos6->GetTileDef()->GetComeFromBelow())
								tiles[x][y]=tileSet->GetTile("9");

							if(pos7==0){
								tiles[x][y]=tileSet->GetTile("12");
							}
							else if(pos9==0){
								tiles[x][y]=tileSet->GetTile("13");
							}

							else{
								tiles[x][y]=tileSet->GetTile("3");
							}
						}

					}
					else if(td->GetIceCovered()){
						//this is an ice covered tile
						if(pos4==0)
							tiles[x][y]=tileSet->GetTile("21");
						else if(pos6==0)
							tiles[x][y]=tileSet->GetTile("22");
						else 
							tiles[x][y]=tileSet->GetTile("15");
					}
					else if(td->GetComeFromBelow()){
						//this is an ice covered tile
						if(pos4==0)
							tiles[x][y]=tileSet->GetTile("18");
						else if(pos6==0)
							tiles[x][y]=tileSet->GetTile("17");
						else
							tiles[x][y]=tileSet->GetTile("1");
					}
				}
			}
		}
	}
}






void Map::Save(){
	ofstream file;
	file.open(filename.c_str(),ios::out);


	//SAVE THE TILES
	for(int y=0 ; y<MAX_MAP_HEIGHT ; y++){
		for(int x=0 ; x<MAX_MAP_WIDTH ; x++)
		{
			if(tiles[x][y]){
				file << tiles[x][y]->GetName() + " ";
			}
			else{
				file << "0 ";
			}
		}
	}

	
	file << enemyList.size();
	file << endl;
	std::list<Enemy*>::iterator it;
	for(it=enemyList.begin() ; it!=enemyList.end(); it++){
		if(*it){
			(*it)->SaveToMapFile(&file);
		}
	}
	file << endl;
	
	file << decorations.size();
	file << endl;
	std::list<MapDecoration*>::iterator decIt;
	for(decIt=decorations.begin() ; decIt!=decorations.end(); decIt++){
		if(*decIt){
			(*decIt)->SaveToMapFile(&file);
		}
	}
	file << endl;


	file.close();

}

void Map::Load(std::string filename){
	DeleteAll();

	this->filename = filename;
	ifstream file;
	file.open(filename.c_str(),ios::in);

	string tileName;

	//LOAD THE TILES
	for(int y=0 ; y<MAX_MAP_HEIGHT ; y++){
		for(int x=0 ; x<MAX_MAP_WIDTH ; x++)
		{
			file >> tileName;
			tiles[x][y] = tileSet->GetTile(tileName);
		}
	}

	int numEnemies;

	file >> numEnemies;

	int i;
	for(i=0 ; i<numEnemies ; i++){
		Enemy *en = new Enemy(&file);
		this->AddEnemy(en);
	}

	int numDecorations;
	file >> numDecorations;

	for(i=0 ; i<numDecorations ; i++){
		MapDecoration *dec = new MapDecoration(&file);
		this->AddDecoration(dec);
	}

	file.close();
}

MapDecoration* Map::AddDecoration(MapDecorationDef *def, int x, int y){
	if(def){
		MapDecoration* decoration = new MapDecoration(def);
		decoration->SetPosition(x,y);
		decorations.push_back(decoration);
		return decoration;
	}
	return 0;
}

void Map::AddDecoration(MapDecoration *decoration){
	if(decoration){
		decorations.push_back(decoration);
	}
}

void Map::AddPickup(Pickup *pickup, float x, float y){
	if(pickup){
		pickup->SetPosition(x,y);
		pickupList.push_back(pickup);
	}
}

void Map::AddEnemy(EnimDef *enimDef, int startingDir, float x, float y){
	if(enimDef){
		Enemy *enemy = new Enemy(enimDef,startingDir);
		enemy->SetPosition(x,y,startingDir);
		enemyList.push_back(enemy);
	}
}

void Map::AddEnemy(Enemy *enemy){
	if(enemy){
		enemyList.push_back(enemy);
	}
}

void Map::ResetEnemies(){
	std::list<Enemy*>::iterator it;
	for(it = enemyList.begin(); it!=enemyList.end() ; it++){
		if((*it)){
			(*it)->Reset();
		}
	}
}

void Map::ResetPickups(){
	list<Pickup*>::iterator it;
	for(it = pickupList.begin(); it!=pickupList.end() ; ){
		Pickup *pickup = (*it);
		it++;
		if(pickup){
			if(pickup->GetType()==Pickup::PRESENT){
				delete pickup;
				pickupList.remove(pickup);
			}
		}
	}
}

void Map::ResetProjectiles(){
	if(projList){
		projList->DeleteAll();
	}
}

void Map::CheckCollsisionWithPickups(Player *p, int msecPassed){
	if(p){
		list<Pickup*>::iterator it;
		for(it = pickupList.begin(); it!=pickupList.end() ; ){
			Pickup* pickup = *it;
			it++;
			if(pickup){
				if(pickup->CheckCollision(p, msecPassed)){
					p->PickUp(pickup);
					delete pickup;
					
					pickupList.remove(pickup);
				}
			}
		}
	}
}

Enemy* Map::CheckCollisionWithEnemy(int x, int y, int msecPassed){
	std::list<Enemy*>::iterator it;
	for(it = enemyList.begin(); it!=enemyList.end() ; it++){
		if( (*it)->CheckCollision(x,y, msecPassed) ){
			return (*it);
		}
	}
	return 0;
}

MapDecoration* Map::CheckCollisionWithDecoration(int x, int y, int msecPassed){
	std::list<MapDecoration*>::iterator it;
	for(it = decorations.begin(); it!=decorations.end() ; it++){
		if( (*it)->CheckCollision(x,y, msecPassed) ){
			return (*it);
		}
	}
	return 0;
}

Actor* Map::CheckCollisionWithActor(int x, int y, int msecPassed){
	Actor *ret;
	
	ret = CheckCollisionWithEnemy(x,y, msecPassed);
	if(ret!=0)
		return ret;
	
	ret = CheckCollisionWithDecoration(x,y, msecPassed);
	if(ret!=0)
		return ret;

	return 0;
}

Enemy* Map::CheckCollisionWithEnemy(Actor* actor, int msecPassed){
	if(actor){
		std::list<Enemy*>::iterator it;
		for(it = enemyList.begin() ; it!=enemyList.end() ; it++){
			Enemy *en = (*it);
			if(en && !en->IsDying() && !en->IsDead()){
				if(actor->CheckCollision(en,msecPassed)){
					return en;
				}
			}
		}
	}
	return 0;
}

int Map::CountLivingElfs(){
	int ret=0;

	std::list<Enemy*>::iterator it;
	for(it = enemyList.begin() ; it!=enemyList.end() ; it++){
		Enemy *en = (*it);
		if(en && !en->IsDead() && !en->IsDying() && en->IsElf()){
			ret++;
		}
	}

	return ret;
}

void Map::SpawnSnowflake(int i, int screenx, int screeny){
	if(i>=0 && i<MAX_SNOW_FLAKES){
		snowflakes[i].x = (rand()%(Constants::BACKGROUND_WIDTH*7)) - Constants::BACKGROUND_WIDTH*3 + screenx;

		snowflakes[i].y = (rand()%100) - 110;



	}
}