#include "Log.h"

Log::Log(void)
{
	this->file.open("log.txt",std::ios::out);
	currentIndent = 0;
}

Log::~Log(void)
{
	logLine("Destroying Logging System");
	if(this->file)
		this->file.close();
	logLine("Done destroying Logging System");
}

Log* Log::inst(){
	static Log instance;

	return &instance;
}

void Log::logLine(std::string message, int indentDelta){

	if(indentDelta <0){
		currentIndent+=indentDelta;
		if(currentIndent <=0)
			currentIndent=0;
	}

	if(this->file && this->file.is_open()){
		for(int i=0 ; i<currentIndent ; i++)
			this->file << "   ";

		this->file << message << std::endl;
	}

	if(indentDelta >0){
		currentIndent+=indentDelta;
	}
}
