#pragma once
#include <iostream>
#include <fstream>
#include "Constants.h"
#include "Character.h"
#include "EnimDef.h"
#include "Map.h"


class Enemy :
	public Character
{
private:
	bool dying;
	bool dead;

	EnimDef *def;

	int originalPosX, originalPosY, originalDir;
	void SetDef(EnimDef *def);
	void LoadFromMapFile(std::ifstream *file);

	bool prevOnGround;
	bool touchedGroundBefore;

	Map *map;
	int deadCounter;
	int flashCounter, flashCounterBase;

public:
	

	Enemy(EnimDef *def, int startingDir);
	Enemy(std::ifstream *file);
	~Enemy(void);

	void Reset();

	void Draw(BITMAP *dest, int screenx, int screeny);
	void Update(int msecPassed,Map *map);
	void ModifyAnimation();

	void HitByProj(Projectile *proj, int msecPassed);

	bool IsDying(){ return dying;}
	bool IsDead() { return dead;}
	void SetPosition(float x, float y, int dir);

	void StartDying();
	void SaveToMapFile(std::ofstream *file);

	bool IsElf() { return def->type==EnimDef::ELF; }
	
};
