#include "Enemy.h"

using namespace std;

Enemy::Enemy(EnimDef* def, int startingDir) : Character(def->hitBox, Character::ENEMY)
{
	dying = false;
	dead = false;
	SetDef(def);
	dir = startingDir;
	prevOnGround = false;
	touchedGroundBefore = false;

	deadCounter=0;
	flashCounter=0; flashCounterBase=0;
	
}

Enemy::Enemy(ifstream *file) : Character(MakeRectangle(0,0,0,0)/*dummy hitbox. Will be replaced by data from file*/, Character::ENEMY)
{
	dying = false;
	dead = false;
	LoadFromMapFile(file);
	prevOnGround = false;
	touchedGroundBefore = false;
	deadCounter=0;
	flashCounter=0;
	flashCounterBase=0;
}

Enemy::~Enemy(void)
{
}

void Enemy::Reset(){
	Character::Reset();
	SetPosition(originalPosX,originalPosY,originalDir);
	dying = false;
	dead = false;
	prevOnGround = false;
	touchedGroundBefore = false;
	GetCurrentAnim()->Reset();
	deadCounter=0;
	flashCounter=0;
	flashCounterBase=0;
}

void Enemy::SetDef(EnimDef *def){
	this->def = def;

	maxThrowPower = def->maxThrowPower;
	jumpSpeed = def->jumpSpeed;
	maxWalkSpeed = def->maxWalkSpeed;
	walkSpeed = def->walkSpeed;
	readyToJumpTime = def->readyToJumpTime;
	readyToThrowTime = def->readyToThrowTime;
	hitBox = def->hitBox;

	std::vector<AnimDef*>::iterator it;
	for(it = def->animDefs.begin(); it!=def->animDefs.end() ; it++){
		AnimDef *animDef = (*it);
		if(animDef)
			AddAnimation(animDef);
	}
}

void Enemy::Draw(BITMAP *dest, int screenx, int screeny){
	//if(!dead){
	if(!dead && (!dying || flashCounter>0)){
		Character::Draw(dest,screenx,screeny);
	}

	//}
}

void Enemy::Update(int msecPassed,Map *map){
	this->map = map;
	if(!dead){
		if(!dying){


			if(def->walks){
				////////TURN AROUND IF HITTING A WALL///////
				if(dir==FACING_LEFT){
					if(this->IsHittingLeft()){
						dir=FACING_RIGHT;
					}
				}
				else if(dir==FACING_RIGHT){
					if(this->IsHittingRight()){
						dir=FACING_LEFT;
					}
				}


				///////TURN AROUND IF ABOUT TO WALK OFF AN EDGE/////////
				if(!def->jumps){
					float checkX, checkY;
					checkY = y+hitBox.y+hitBox.h+10;
					if(dir==FACING_LEFT){
						checkX = x+hitBox.x - 30;
					}
					else{
						checkX = x+hitBox.x + hitBox.w + 30;
					}
					
					if( map->GetTileAt(checkX,checkY)==0 ){
						if(dir==FACING_LEFT) dir=FACING_RIGHT;
						else if(dir==FACING_RIGHT) dir=FACING_LEFT;
					}
				}


				/////DO MOVEMENT////
				if(dir==FACING_LEFT)
					this->WalkLeft();
				else if(dir==FACING_RIGHT)
					this->WalkRight();
			}

			if(def->jumps){
				this->Jump(msecPassed);
			}

			if(def->throws){
				
			}
		}
		else if(deadCounter>0){		//is dead
			deadCounter-=msecPassed;

			if(deadCounter<3000){
				if(flashCounter > -flashCounterBase/2){
					flashCounter-=msecPassed;
				}
				else{
					flashCounterBase/=1.5;
					flashCounter = flashCounterBase;
				}
			}
		}
		else{
			dead = true;
		}
		Character::Update(msecPassed,map);
	}

}

void Enemy::HitByProj(Projectile *proj, int msecPassed){
 	if(!dying && !dead && proj){
		switch(proj->GetType()){
			case Projectile::PRESENT:
				if(this->def->type==EnimDef::ELF){
					if(proj->GetCentreY() < this->GetCentreY() - 20){
						//proj->Kill();
						StartDying();

						if(map){
							MapDecoration* decoration = map->AddDecoration((MapDecorationDef*)ResourceManager::inst()->GetResource("hatDecoration"),x,y);
							if(decoration){
								float fx,fy;
								fy = -0.5f / ((float)msecPassed);
								if(proj->GetVelX() > 0){
									fx=0.5f/((float)msecPassed);
								}
								else{
									fx=-0.5f/((float)msecPassed);
								}
								decoration->ApplyForce(fx,fy);
							}
						}
					}
				}
				break;
		}
	}
}

void Enemy::StartDying(){
	if(!dying){
		dying = true;
		SetCurrentAnim(1);
		deadCounter = 6000;
		flashCounterBase = 400;
		flashCounter = flashCounterBase;
	}	
}

void Enemy::SetPosition(float x, float y, int dir){
	originalPosX = x;
	originalPosY = y;
	originalDir = dir;
	Character::SetPosition(x,y,dir);
}

void Enemy::SaveToMapFile(ofstream *file){
	(*file) << this->def->GetName()->c_str() << '\t';
	(*file) << this->originalPosX << '\t';
	(*file) << this->originalPosY << '\t';
	(*file) << this->dir << endl;
}

void Enemy::LoadFromMapFile(ifstream *file){
	int tx,ty,tdir;
	EnimDef *def = 0;
	std::string defName;

	(*file) >> defName;
	(*file) >> tx;
	(*file) >> ty;
	(*file) >> tdir;

	def = (EnimDef*)ResourceManager::inst()->GetResource(defName);
	if(def){
		SetDef(def);
	}
	SetPosition(tx,ty,tdir);
}

void Enemy::ModifyAnimation(){
	Anim* curAnim = GetCurrentAnim();
	if(curAnim){
		if(type==EnimDef::ELF){
			if(dying){
				
			}
		}

		if(def->jumps){
			curAnim->Pause();

			if(!touchedGroundBefore && IsOnGround()){
				curAnim->SetFrame(0);
				touchedGroundBefore = true;
				prevOnGround = true;
			}
			else if(prevOnGround!=IsOnGround()){
				curAnim->NextFrame();
				prevOnGround = IsOnGround();
			}

			/*if(!walking || !IsOnGround()){
				curAnim->Pause();
				curAnim->Reset();
			}
			else{
				curAnim->Start();
			}*/
		}
	}

}
