#include "AnimDef.h"

using namespace std;

AnimDef::AnimDef(const char *name) : Resource(name)
{
	frames = new vector<AnimFrame>();
}

AnimDef::~AnimDef(void)
{
	if(frames){
		frames->clear();
		delete frames;
	}
}

void AnimDef::AddFrame(AnimFrame frame)
{
	frames->push_back(frame);
}

int AnimDef::CountFrames(){
	if(frames){
		return frames->size();
	}
	return 0;
}


AnimFrame* AnimDef::GetFrame(int n){
	if(frames && n>=0 && n<CountFrames()){
		return &frames->at(n);
	}
	return 0;
}

AnimFrame MakeFrame(Image *img, int duration, int offsetX, int offsetY){
	AnimFrame ret = {img,duration,offsetX,offsetY};
	return ret;
}