#pragma once
#include "AnimDef.h"

#include <allegro.h>
#include <string>

class Anim
{
private:
	AnimDef *animDef;
	AnimFrame *currentFrame;
	bool running;
	int curFrameIndex;
	int timeLeft;
	bool loop, finished;

public:
	Anim(AnimDef *animDef);
	~Anim(void);

	void Draw(BITMAP *dest, int x, int y);
	void DrawFlipped(BITMAP *dest, int x, int y);
	void Update(int msecPassed);
	void SetFrame(int n);
	void Stop();
	void Start(bool loop=true);
	void Pause();
	void Reset();
	void NextFrame();
	AnimDef* GetDef() { return animDef; }

	bool IsRunning(){ return running; }
	bool IsFinished() { return finished; }
};
