#include "Actor.h"
#include "Map.h"

Actor::Actor(Rectangle hitBox, bool moveable, bool bounces)
{
	this->hitBox = hitBox;
	x=0;
	y=0;
	velX = 0;
	velY = 0;
	accelX = 0;
	accelY = 0;
	isOnGround = false;
	isHittingLeft = false;
	isHittingRight = false;
	this->moveable = moveable;
	this->bounces = bounces;
	currentAnim=0;
	currentSurfaceFriction=0;
}

void Actor::Reset(){
	x=0;
	y=0;
	velX = 0;
	velY = 0;
	accelX = 0;
	accelY = 0;	
	isOnGround = false;
	isHittingLeft = false;
	isHittingRight = false;
	currentAnim=0;
	currentSurfaceFriction=0;
}

Actor::~Actor(void)
{
	animations.clear();
}

void Actor::AddAnimation(AnimDef *animDef){
	if(animDef){
		animations.push_back(Anim(animDef));
	}
}

void Actor::Draw(BITMAP *dest, int screenx, int screeny, bool flipped){
	//rect(dest, x+hitBox.x - screenx, y+hitBox.y - screeny, x+hitBox.x+hitBox.w - screenx, y+hitBox.y+hitBox.h - screeny,makecol(255,0,0));

	if(currentAnim>=0 && currentAnim<animations.size()){
		if(flipped)
			animations[currentAnim].DrawFlipped(dest,x-screenx,y-screeny);
		else
			animations[currentAnim].Draw(dest,x-screenx,y-screeny);
	}
}


void Actor::ClearForces(){
	accelX = 0;
	accelY = 0;
}

void Actor::ApplyForce(float fx, float fy){
	accelX += fx;
	accelY += fy;
}

void Actor::ModifyVel(float deltax, float deltay){
	velX += deltax;
	velY += deltay;
}

Anim* Actor::GetCurrentAnim(){
	if(currentAnim>=0 && currentAnim<animations.size()){
		return &animations[currentAnim];
	}
	return 0;
}

void Actor::SetCurrentAnim(unsigned int index){
	if(index>=0 && index<animations.size()){
		currentAnim = index;
		animations[currentAnim].Reset();
		animations[currentAnim].Start();
	}
}

void Actor::Update(int msecPassed,Map *map){
	if(moveable){
		/*velX += accelX;
		velY += accelY;

		float targetX = x + velX * msecPassed;
		float targetY = y + velY * msecPassed;*/

		float targetX, targetY;
		targetX = x + velX*msecPassed + 0.5*accelX*(msecPassed*msecPassed);
		targetY = y + velY*msecPassed + 0.5*accelY*(msecPassed*msecPassed);

		velX = velX + accelX*msecPassed;
		velY = velY + accelY*msecPassed;

		
		if(targetX<0){
			targetX=0;
			velX=0;
		}

		MoveDown(map, targetX, targetY);
		MoveUp(map, targetX, targetY);
		MoveLeft(map, targetX, targetY);
		MoveRight(map, targetX, targetY);

		if(velX > 0){
			velX -= currentSurfaceFriction * msecPassed;
			if(velX<0)
				velX=0;
		}
		else if(velX < 0){
			velX += currentSurfaceFriction * msecPassed;
			if(velX>0)
				velX=0;
		}

	}

	if(currentAnim>=0 && currentAnim<animations.size()){
		animations[currentAnim].Update(msecPassed);
	}
}

void Actor::EnforceMaxXSpeed(float speed){
	if(ABS(velX) > speed){
		if(velX<0)
			velX = -speed;
		else
			velX = speed;
	}
}

void Actor::MoveUp(Map *map, float targetX, float targetY){
	bool hasHit;
	if(targetY < y){
		isOnGround=false;
		for(int yy = y + hitBox.y ; yy>targetY + hitBox.y ; yy--){
			hasHit = false;
			for(int xx = x+hitBox.x+1 ; xx<x+hitBox.x+hitBox.w-1 ; xx++){
				Tile *t = map->GetTileAt(xx,yy);
				if(t!=0 && t->GetTileDef() && t->GetTileDef()->GetComeFromBelow()==false){
					hasHit=true;
					break;
				}
			}
			if(hasHit){
				if(ABS(velY)<0.2 || !bounces)
					velY=0;
				else
					velY = -velY/2;

				y=yy - hitBox.y;
				return;
			}

		}
		y = targetY;
	}
}

void Actor::MoveDown(Map *map, float targetX, float targetY){
	bool hasHit;
	if(targetY > y){
		int tileContactCount=0;
		currentSurfaceFriction = 0.0f;

		Tile *t=0;
		for(int yy = y + hitBox.y+hitBox.h ; yy<targetY + hitBox.y+hitBox.h ; yy++){
			hasHit = false;
			for(int xx = x+hitBox.x+1 ; xx<x+hitBox.x+hitBox.w-1 ; xx++){
				t = map->GetTileAt(xx,yy);
				if(t!=0){
					hasHit=true;
					currentSurfaceFriction += t->GetFrictionValue();
					tileContactCount++;
					//break;
				}
			}
			if(hasHit){
				
				if(ABS(velY)<0.2 || !bounces)
					velY=0;
				else
					velY = -velY/2;
				

				isOnGround = true;
				y=yy - hitBox.y - hitBox.h;
				y-= ((int)yy)%TILE_HEIGHT;
				

				currentSurfaceFriction /= tileContactCount;	//get average surface friction
				return;
			}
		}
		isOnGround=false;
		y = targetY;
	}
}

void Actor::MoveLeft(Map *map, float targetX, float targetY){
	bool hasHit;
	if(targetX < x){
		isHittingRight=false;
		for(int xx = x + hitBox.x ; xx>targetX + hitBox.x ; xx--){
			hasHit = false;
			for(int yy = y+hitBox.y+1 ; yy<y+hitBox.y+hitBox.h-1 ; yy++){
				Tile *t = map->GetTileAt(xx,yy);
				if(t!=0 && t->GetTileDef() && !t->GetTileDef()->GetComeFromBelow()){
					hasHit=true;
					break;
				}
			}
			if(hasHit){
				isHittingLeft = true;
				if(ABS(velX)<0.1 || !bounces)
					velX=0;
				else
					velX = -velX/2;

				x=xx - hitBox.x;
				return;
			}

		}
		isHittingLeft=false;
		x = targetX;
	}
}

void Actor::MoveRight(Map *map, float targetX, float targetY){
	bool hasHit;
	if(targetX > x){
		isHittingLeft=false;
		for(int xx = x + hitBox.x+hitBox.w ; xx<targetX + hitBox.x+hitBox.w ; xx++){
			hasHit = false;
			for(int yy = y+hitBox.y+1 ; yy<y+hitBox.y+hitBox.h-1 ; yy++){
				Tile *t = map->GetTileAt(xx,yy);
				if(t!=0 && t->GetTileDef() && !t->GetTileDef()->GetComeFromBelow()){
					hasHit=true;
					break;
				}
			}
			if(hasHit){
				isHittingRight =true;
				if(ABS(velX)<0.1 || !bounces)
					velX=0;
				else
					velX = -velX/2;

				x=xx - hitBox.x - hitBox.w;
				return;
			}

		}
		isHittingRight=false;
		x = targetX;
	}
}

bool Actor::CheckCollisionWithMap(int positionX, int positionY, Map *map){
	if(map){
		int leftPos = (int)positionX + hitBox.x;
		int topPos = (int)positionY + hitBox.y;


		/*for(int ty = topTileVal ; ty < topTileVal+heightInTiles ; ty++){
			for(int tx = leftTileVal ; tx<leftTileVal+widthInTiles ; tx++){
				if(map->GetTile(tx,ty)!=0){
					ret
				}
			}
		}*/

		for(int yy = topPos ; yy< topPos + hitBox.h ; yy++){
			for(int xx = leftPos ; xx < leftPos + hitBox.w ; xx++){
				if(map->GetTileAt(xx,yy)!=0){
					return true;
				}
			}
		}
	}

	return false;
}

bool Actor::IsOnGround(){
	return isOnGround;
}

bool Actor::CheckCollision(Actor *other, int msecPassed){
	if(other){
		
		if (this->y+this->hitBox.y+this->hitBox.h < other->y+other->hitBox.y) return false;
		if (this->y+this->hitBox.y > other->y+other->hitBox.y+other->hitBox.h) return false;

		if (this->x+this->hitBox.x+this->hitBox.w < other->x+other->hitBox.x) return false;
		if (this->x+this->hitBox.x > other->x+other->hitBox.x+other->hitBox.w) return false;

		return true;
	}

	return false;
}

bool Actor::CheckCollision(int px, int py, int msecPassed){
	if(px >= x+hitBox.x && px < x+hitBox.x+hitBox.w &&
		py >= y+hitBox.y && py < y+hitBox.y+hitBox.h){
		return true;
	}
	return false;
}
