#pragma once

#include <map>
#include <string>
#include <vector>
#include "Tile.h"
#include "EnimDef.h"
#include "MapDecorationDef.h"

typedef std::map<std::string , Tile>::iterator TileIterator;
typedef std::vector<EnimDef*>::iterator EnimDefIterator;
typedef std::vector<MapDecorationDef*>::iterator DecorationDefIterator;

class TileSet
{
private:
	std::map<std::string , Tile> tiles;
	std::vector<EnimDef*> enimDefs;
	std::vector<MapDecorationDef*> decorationDefs;

public:
	TileSet(void);
	~TileSet(void);

	void AddTile(Tile tile);
	Tile* GetTile(std::string name);
	TileIterator GetTileIterator();
	Tile* GetTileAt(TileIterator pos);
	void NextTile(TileIterator *pos);
	void PrevTile(TileIterator *pos);

	void AddEnimDef(EnimDef *enimDef);
	EnimDefIterator GetEnimDefIterator();
	EnimDef* GetEnimDefAt(EnimDefIterator pos);
	void NextEnimDef(EnimDefIterator *pos);
	void PrevEnimDef(EnimDefIterator *pos);
	int CountEnimDefs() { return enimDefs.size(); }

	void AddDecorationDef(MapDecorationDef *enimDef);
	DecorationDefIterator GetDecorationDefIterator();
	MapDecorationDef* GetDecorationDefAt(DecorationDefIterator pos);
	void NextDecorationDef(DecorationDefIterator *pos);
	void PrevDecorationDef(DecorationDefIterator *pos);
	int CountDecorationDefs() { return decorationDefs.size(); }
};
