#include "TileSet.h"

TileSet::TileSet(void)
{
}

TileSet::~TileSet(void)
{
	tiles.clear();
	enimDefs.clear();
}

void TileSet::AddTile(Tile tile){
	tiles[tile.GetName()] = tile;
}

Tile* TileSet::GetTile(std::string name){
	if(tiles.count(name)>0){
		return &tiles[name];
	}

	return 0;
}

TileIterator TileSet::GetTileIterator(){
	return tiles.begin();
}

Tile* TileSet::GetTileAt(TileIterator pos){
	return &((*pos).second);
}

void TileSet::NextTile(TileIterator *pos){
	if( (*pos)!=tiles.end() ){
		(*pos)++;
	}
	
	if((*pos)==tiles.end()){
		(*pos) = tiles.begin();
	}
}


void TileSet::PrevTile(TileIterator *pos){
	if( (*pos) != tiles.begin()){
		(*pos)--;
	}

	if((*pos)==tiles.begin()){
		(*pos) = tiles.end();
		(*pos)--;
	}
}



void TileSet::AddEnimDef(EnimDef *enimDef){
	enimDefs.push_back(enimDef);
}


EnimDefIterator TileSet::GetEnimDefIterator(){
	return enimDefs.begin();
}

EnimDef* TileSet::GetEnimDefAt(EnimDefIterator pos){
	return (*pos);
}

void TileSet::NextEnimDef(EnimDefIterator *pos){
	if( (*pos)!=enimDefs.end() ){
		(*pos)++;
	}
	
	if((*pos)==enimDefs.end()){
		(*pos) = enimDefs.begin();
	}
}

void TileSet::PrevEnimDef(EnimDefIterator *pos){
	if( (*pos) != enimDefs.begin()){
		(*pos)--;
	}

	if((*pos)==enimDefs.begin()){
		(*pos) = enimDefs.end();
		(*pos)--;
	}
}


void TileSet::AddDecorationDef(MapDecorationDef *decorationDef){
	if(decorationDef){
		decorationDefs.push_back(decorationDef);
	}
}

DecorationDefIterator TileSet::GetDecorationDefIterator(){
	return decorationDefs.begin();
}

MapDecorationDef* TileSet::GetDecorationDefAt(DecorationDefIterator pos){
	MapDecorationDef *ret;
	ret = (*pos);
	return ret;
}

void TileSet::NextDecorationDef(DecorationDefIterator *pos){
	if( (*pos)!=decorationDefs.end() ){
		(*pos)++;
	}
	
	if((*pos)==decorationDefs.end()){
		(*pos) = decorationDefs.begin();
	}
}

void TileSet::PrevDecorationDef(DecorationDefIterator *pos){
	if( (*pos) != decorationDefs.begin()){
		(*pos)--;
	}

	if((*pos)==decorationDefs.begin()){
		(*pos) = decorationDefs.end();
		(*pos)--;
	}
}
