#pragma once
#include "Resource.h"
#include <string>
#include "Constants.h"
#include "ResourceManager.h"
#include "Image.h"
#include "AnimDef.h"




class TileDef :
	public Resource
{
private:
	Image *image;
	AnimDef *animDef;

	Rectangle hitBox;
	bool comeFromBelow;	//tile property: can the character pass through it from below?
	bool iceCovered;	//tile property: is the tile ice covered?
	bool openTop, openLeft, openRight;
	
	void Init(Image *image, Rectangle hitBox, bool comeFromBelow, bool iceCovered, bool openTop, bool openLeft, bool openRight);
public:
	TileDef(const char *name, Image *image, Rectangle hitBox, bool comeFromBelow, bool iceCovered, bool openTop, bool openLeft, bool openRight);
	TileDef(const char *name, std::string imageName, Rectangle hitBox, bool comeFromBelow, bool iceCovered, bool openTop, bool openLeft, bool openRight);
	~TileDef(void);

	Image* GetImage() { return image; }
	Rectangle GetHitBox() { return hitBox;}

	bool GetComeFromBelow() { return comeFromBelow;}
	bool GetIceCovered() { return iceCovered;}
	bool HasOpenTop();
	bool HasOpenLeft();
	bool HasOpenRight();
};
