#pragma once

#include <allegro.h>
#include <string>
#include "Image.h"
#include "TileDef.h"

class Tile
{
private:
	TileDef *tileDef;
	float frictionValue;
	std::string name;

public:
	Tile();
	Tile(std::string name, TileDef *tileDef);
	~Tile(void);

	void SetTileDef(TileDef *tileDef);
	void Draw(BITMAP *dest, int x, int y);
	void Update(int msecPassed);


	bool IsPositionInHitBox(int x, int y);

	float GetFrictionValue(){ return frictionValue; }
	TileDef* GetTileDef(){ return tileDef; }

	void Cleanup(bool openTop, bool openLeft, bool openRight);

	std::string GetName() {return name;}
};
