#include "Song.h"

Song::Song(const char *namechar, const char *songFilename) : Resource(namechar)
{
	Log::inst()->logLine("Creating song. Name: ["+(*name)+"]");

	song = load_midi(songFilename);

	if(!song){
		Log::inst()->logLine("error loading song at " + std::string(songFilename) + ".");
	}

}

Song::~Song(void)
{
	if(song)
		destroy_midi(song);
}

void Song::Play(bool looped){
	if(song){
		if(looped)
			play_midi(song,1);
		else
			play_midi(song,0);
	}
}
