#include "ProjectileList.h"


using namespace std;

ProjectileList::ProjectileList(void)
{
}

ProjectileList::~ProjectileList(void)
{
	Log::inst()->logLine("Destroying the Projectile List",1);
	
	DeleteAll();

	Log::inst()->logLine("Done destroying the Projectile List",-1);
}

void ProjectileList::DeleteAll(){
	list<Projectile*>::iterator it;
	for(it = projectileList.begin() ; it!=projectileList.end(); it++){
		Projectile *toDelete = (*it);
		delete toDelete;
		
	}
	projectileList.clear();
}

void ProjectileList::Draw(BITMAP *dest, int screenx, int screeny){
	if(projectileList.size()>0){
		list<Projectile*>::iterator iter;
		for(iter = projectileList.begin(); iter!=projectileList.end(); iter++){
			if((*iter)){
				(*iter)->Draw(dest,screenx,screeny);
			}
		}
	}
}

void ProjectileList::ClearForces(){
	if(projectileList.size()>0){
		list<Projectile*>::iterator iter, toDelete;
		for(iter = projectileList.begin(); iter!=projectileList.end(); iter++){
			(*iter)->ClearForces();
		}
	}
}

void ProjectileList::Update(int msecPassed,Map *map){
	bool somethingDeleted;

	if(projectileList.size()>0){
		list<Projectile*>::iterator iter, toDelete;

		for(iter = projectileList.begin(); iter!=projectileList.end(); ){
			somethingDeleted = false;
			if((*iter)){
				if((*iter)->IsAffectedByGravity())
					(*iter)->ApplyForce(0,GRAVITY);
				(*iter)->Update(msecPassed,map);
				if( (*iter)->ShouldDestroy() ){
					toDelete = iter;
					somethingDeleted = true;
				}
			}
			iter++;

			if(somethingDeleted){
				delete (*toDelete);
				projectileList.erase(toDelete);
			}
		}
	}
}

void ProjectileList::AddProjectile(Projectile *proj){
	projectileList.push_back(proj);
}

