#pragma once
#include <math.h>
#include "Log.h"
#include "Actor.h"
#include "Pickup.h"

class Projectile :
	public Actor
{
private:
	bool shouldDestroy;
	bool affectedByGravity;
	int owner;
	int type;

	void SpawnPickup(Map *map);
public:
	static const int PRESENT = 1;


	Projectile(Rectangle hitBox, int owner, int type, bool affectedByGravity=true);
	~Projectile(void);

	void Draw(BITMAP *dest, int screenx, int screeny);
	void Update(int msecPassed,Map *map);

	bool ShouldDestroy() { return shouldDestroy; }
	void Kill() { shouldDestroy = true; }
	bool IsAffectedByGravity() { return affectedByGravity;}
	void Shoot(int msecPassed, float x, float y, float angle, float speed);
	int GetOwner() { return owner; } 
	int GetType() { return type; }
};
