#include "Projectile.h"

#include "Map.h"

Projectile::Projectile(Rectangle hitBox, int owner, int type, bool affectedByGravity) : Actor(hitBox,true,true)
{
	shouldDestroy=false;
	this->affectedByGravity = affectedByGravity;
	this->owner = owner;
	this->type = type;
	ClearForces();
}

Projectile::~Projectile(void)
{
}

void Projectile::Draw(BITMAP *dest, int screenx, int screeny){
	Actor::Draw(dest,screenx,screeny);

}

void Projectile::Update(int msecPassed,Map *map){
	Actor::Update(msecPassed,map);


	if(GetY() > MAX_MAP_HEIGHT*TILE_HEIGHT){
		shouldDestroy=true;
	}

	else if( ABS(velX) < 0.001 && ABS(velY)<0.001 && IsOnGround()){
		shouldDestroy=true;
		SpawnPickup(map);
	}
}

void Projectile::SpawnPickup(Map *map){
	if(type==Projectile::PRESENT){
		Pickup *p = new Pickup(hitBox,Pickup::PRESENT);
		p->AddAnimation(GetCurrentAnim()->GetDef());
		map->AddPickup(p,GetX(),GetY());
	}
}

void Projectile::Shoot(int msecPassed, float x, float y, float angle, float speed){
	float vx,vy;
	vx = cos(angle) * (speed/msecPassed);
	vy = sin(angle) * (speed/msecPassed);

	SetPosition(x,y);
	//SetVel(vx,vy);
	ApplyForce(vx,vy);
}


