#include "Player.h"

Player::Player(Rectangle hitBox) : Character(hitBox, Character::PLAYER)
{
	ammo=0;
	Reset();

	hudFont = ((Font*)ResourceManager::inst()->GetResource("goudy18Font"))->GetFont();
	hudHeartImage = (Image*)ResourceManager::inst()->GetResource("heartImage");
	hudPresentImage = (Image*)ResourceManager::inst()->GetResource("presentHUDImage");
	elfsLeft=1;

	dyingMessage1Font = ((Font*)ResourceManager::inst()->GetResource("goudy14Font"))->GetFont();
	dyingMessage2Font = ((Font*)ResourceManager::inst()->GetResource("goudy10Font"))->GetFont();
}

Player::~Player(void)
{
}

void Player::Reset(){
	Character::Reset();

	maxHealth = 3;
	health = maxHealth;
	invincibleCounter=0;
	dying = false;
	dead = false;
	flashCounter=0;
	startNextLevel = false;
}

void Player::Draw(BITMAP *dest, int screenx, int screeny){
	if(!dead){
		if(flashCounter>=0)
			Character::Draw(dest,screenx,screeny);

		if(dying){
			rectfill(dest,70,170,Constants::BACKGROUND_WIDTH-70,313,makecol(40,40,40));
			if(dyingMessage1Font)
				textprintf_centre_ex(dest,dyingMessage1Font,Constants::BACKGROUND_WIDTH/2,200,makecol(30,100,200),-1,"Ouch, watch out for those elfs!");
			if(dyingMessage2Font)
				textprintf_centre_ex(dest,dyingMessage2Font,Constants::BACKGROUND_WIDTH/2,260,makecol(60,130,230),-1,"Hit ENTER to restart the level");
		}

		if(elfsLeft==0 && curLevelNum!=3 /*only write this if it isn't the last level. HUGE HACK*/){
			rectfill(dest,40,170,Constants::BACKGROUND_WIDTH-40,313,makecol(40,40,40));
			if(dyingMessage1Font)
				textprintf_centre_ex(dest,dyingMessage1Font,Constants::BACKGROUND_WIDTH/2,200,makecol(30,100,200),-1,"Yay! You've saved all the elfs here!");
			if(dyingMessage2Font)
				textprintf_centre_ex(dest,dyingMessage2Font,Constants::BACKGROUND_WIDTH/2,260,makecol(60,130,230),-1,"Hit ENTER to go to the next level");
		}
	}
}

void Player::DrawHUD(BITMAP *dest){
	DrawPowerBar(dest, 20,20);
	
	if(hudHeartImage){
		for(int i=0 ; i<health ; i++){
			hudHeartImage->Draw(dest,70+i*(hudHeartImage->Width()+5),28);
		}
	}

	if(hudPresentImage){
		for(int i=0 ; i<ammo ; i++){
			hudPresentImage->Draw(dest,70+i*(hudPresentImage->Width()+5),70);
		}
	}



	if(hudFont)
		textprintf_ex(dest,hudFont,270,40,makecol(30,100,200),-1,"Elfs Left: %d",elfsLeft);
}

void Player::DrawPowerBar(BITMAP *dest, int x, int y){
	static int powerBarHeight = 90;
	static int powerBarWidth = 25;

	float percentPower = (currentThrowPower-startingThrowPower) / (maxThrowPower-startingThrowPower);
	int powerHeight = (int)(percentPower * (float)powerBarHeight);

	rectfill(dest,x-3,y-3,x+powerBarWidth+3,y+powerBarHeight+3,makecol(100,150,200));

	if(powerHeight>0){
		rectfill(dest,x,y+powerBarHeight-powerHeight,x+powerBarWidth,y+powerBarHeight,makecol(30,100,250));
	}
}

void Player::Update(int msecPassed,Map *map){
	if(map){
		elfsLeft = map->CountLivingElfs();
	}


	if(!dead){
		Character::Update(msecPassed,map);
		ReactToAnimationsFinishing(msecPassed);

		if(dying){
			if(key[KEY_ENTER])
				Die(map);
		}
		else if(elfsLeft==0){
			if(key[KEY_ENTER] || curLevelNum==3 /*Only need to wait for enter if this isn't the last level. HUGE HACK*/){
				startNextLevel=true;
			}
		}
		else{
			if(invincibleCounter>0){
				int flashBase;
				if(invincibleCounter < 1000)
					flashBase = 50;
				else
					flashBase = 100;
				if(flashCounter>-flashBase){
					flashCounter-=msecPassed;
					if(flashCounter<=-flashBase)
						flashCounter=flashBase;
				}

				invincibleCounter-=msecPassed;
				if(invincibleCounter<0){
					invincibleCounter=0;
					flashCounter=0;
				}
			}

		}

	}
	
}

void Player::ReactToAnimationsFinishing(int msecPassed){
	Anim* curAnim = GetCurrentAnim();
	if(curAnim && curAnim->IsFinished()){

		switch( GetCurrentAnimIndex() ){
			case 0:	//main walking anim.
				//don't do anything for now
				break;
			case 1: //throwing anim
   				if(currentlyThrowing){
					ThrowProjectile(msecPassed,projList);
					SetCurrentAnim(0);	//set it back to the main walking anim 
				}
				break;
		}
	}
}

void Player::PickUp(Pickup *pickup){
	if(pickup){
		if(pickup->GetType()==Pickup::PRESENT){
			ammo++;
		}
	}
}

void Player::HitByProj(Projectile *proj, int msecPassed){
	if(proj){
		proj->Kill();
	}
}

void Player::HitByEnemy(Enemy *enemy, int msecPassed){
	if(!dead){
		if(enemy && invincibleCounter==0 && !dying){
			health--;
			if(health<=0)
				StartDying();

			invincibleCounter = 3700;
		}
	}
}

void Player::SetPosition(float x, float y, int dir){
	Character::SetPosition(x,y,dir);

	originalX = x;
	originalY = y;
	originalDir = dir;
}

void Player::StartDying(){
	dying = true;
}

void Player::StartLevel(Map *map, int levelNum){
	Reset();
	SetPosition(originalX,originalY,originalDir);

	map->ResetEnemies();
	map->ResetPickups();
	map->ResetProjectiles();
	
	this->curLevelNum = levelNum;

	SetAmmo(map->GetStartingAmmo());
}

bool Player::ShouldStartNextLevel(){
	return startNextLevel;
}

void Player::Die(Map *map){
	StartLevel(map,curLevelNum);
}

void Player::StartThrowingProjectile(int msecPassed, ProjectileList *projList){
	if(projList){
		this->projList = projList;
		if(ammo>0){
			Anim* curAnim = GetCurrentAnim();
			if(curAnim){
				curAnim->Start(false);
			}
		}
	}
}

void Player::ThrowProjectile(int msecPassed, ProjectileList *projList){
	if(projList && ammo>0){
		ammo--;
		Character::ThrowProjectile(msecPassed,projList);
	}
}

void Player::ModifyAnimation(){
	Anim* curAnim = GetCurrentAnim();
	if(curAnim){
		if(currentlyThrowing){	//this means that the player just started charging a throw
			if(GetCurrentAnimIndex()!=1){
				SetCurrentAnim(1);	//set it to the 2nd (throwing animation) HACK
				Anim* curAnim = GetCurrentAnim();
				if(curAnim){
					curAnim->Pause();
				}
			}
		}
		else{	//if he's not throwing, deal with walking anims
			if(!walking || !IsOnGround()){
				curAnim->Pause();
				curAnim->Reset();
			}
			else{
				curAnim->Start();
			}
		}
	}
}

void Player::Jump(int msecPassed){
	if(!dying && !dead){
		Character::Jump(msecPassed);
	}
}

void Player::WalkLeft(){
	if(!dying && !dead){
		Character::WalkLeft();
	}
}

void Player::WalkRight(){
	if(!dying && !dead){
		Character::WalkRight();
	}
}
