#pragma once
#include <allegro.h>
#include "TileSet.h"
#include "Map.h"
#include "Camera.h"
#include "Actor.h"
#include "MapDecorationDef.h"
#include "MapDecoration.h"
#include "EnimDef.h"
#include "Character.h"
#include "Enemy.h"


class MapEditor
{
private:
	Map *map;
	int cursorX, cursorY;
	int actorPlacementCameraX, actorPlacementCameraY;
	int keyPressCounter;
	Tile* currentTileToPlace;
	TileIterator tileIterator;
	EnimDefIterator enimDefIterator;
	EnimDef *enimToPlace;
	int enimDir;

	MapDecorationDef *decorationToPlace;
	DecorationDefIterator decorationDefIterator;

	int mode;

	bool mouseButtonPressed;
	bool draggingActor;
	Actor* actorBeingDragged;
	Actor *actorUnderMouse;

public:
	static const int DRAWING_TILES=0;
	static const int PLACING_ENEMY=1;
	static const int PLACING_DECORATIONS=2;

	MapEditor(Map *map);
	~MapEditor(void);

	void Draw(BITMAP *dest, int screenx, int screeny);
	bool Update(int msecPassed, Camera *camera);	//returns true when done

	void CheckInput(int msecPassed, Camera *camera);

	int GetCursorX(){return cursorX*TILE_WIDTH;}
	int GetCursorY(){return cursorY*TILE_HEIGHT;}

	int GetCameraFocusX();
	int GetCameraFocusY();
};
