#include "MapEditor.h"

MapEditor::MapEditor(Map *map)
{
	this->map = map;
	tileIterator = this->map->GetTileSet()->GetTileIterator();
	enimDefIterator = this->map->GetTileSet()->GetEnimDefIterator();
	decorationDefIterator = this->map->GetTileSet()->GetDecorationDefIterator();
	cursorX=0;
	cursorY=0;
	keyPressCounter=0;
	currentTileToPlace = this->map->GetTileSet()->GetTileAt(tileIterator);
	
	mode = DRAWING_TILES;

	if(this->map->GetTileSet()->CountEnimDefs()>0){
		enimToPlace = this->map->GetTileSet()->GetEnimDefAt(enimDefIterator);
	}
	else{
		enimToPlace = 0;
	}
	enimDir = Character::FACING_LEFT;

	
	actorPlacementCameraX=Constants::BACKGROUND_WIDTH/2; actorPlacementCameraY=Constants::BACKGROUND_HEIGHT/2;


	mouseButtonPressed=false;
	draggingActor=false;
	actorBeingDragged=0;
	actorUnderMouse=0;

	decorationToPlace=0;
}

MapEditor::~MapEditor(void)
{
}

void MapEditor::Draw(BITMAP *dest, int screenx, int screeny){
	
	if(mode==DRAWING_TILES){
		rect(dest,cursorX*TILE_WIDTH - screenx , cursorY*TILE_HEIGHT - screeny, cursorX*TILE_WIDTH - screenx+TILE_WIDTH , cursorY*TILE_HEIGHT - screeny+TILE_HEIGHT,makecol(200,0,0));
		if(currentTileToPlace)
			currentTileToPlace->Draw(dest,cursorX*TILE_WIDTH - screenx , cursorY*TILE_HEIGHT - screeny);
	}
	else if(mode==PLACING_ENEMY){
		if(enimToPlace!=0 && actorUnderMouse==0 && !draggingActor){
			enimToPlace->DrawAt(dest,mouse_x,mouse_y,(enimDir==Character::FACING_LEFT));
		}
	}
	else if(mode==PLACING_DECORATIONS){
		if(decorationToPlace!=0 && actorUnderMouse==0 && !draggingActor){
			decorationToPlace->DrawAt(dest,mouse_x,mouse_y);
		}
	}

	circle(dest,mouse_x,mouse_y,3,makecol(0,0,255));
	circlefill(dest,mouse_x,mouse_y,1,makecol(0,0,255));
}


bool MapEditor::Update(int msecPassed, Camera *camera){
	if(key[KEY_E]){
		while(key[KEY_E]);
		return true;	
	}
	CheckInput(msecPassed,camera);	

	return false;
}

void MapEditor::CheckInput(int msecPassed, Camera *camera){
	if(key[KEY_LEFT] || key[KEY_RIGHT] || key[KEY_UP] || key[KEY_DOWN] || key[KEY_S] || key[KEY_ENTER] || key[KEY_C] || key[KEY_DEL] || key[KEY_PGUP] || key[KEY_PGDN] || key[KEY_SPACE] || key[KEY_X]){

		if(keyPressCounter==0){
			keyPressCounter = 60;

			if(mode==DRAWING_TILES){
				if(key[KEY_LEFT] && cursorX>0){
					cursorX-=1;
				}
				else if(key[KEY_RIGHT] && cursorX+1 < MAX_MAP_WIDTH){
					cursorX+=1;
				}
							
				if(key[KEY_UP] && cursorY>0){
					cursorY-=1;
				}
				else if(key[KEY_DOWN] && cursorY+1 < MAX_MAP_HEIGHT){
					cursorY+=1;
				}
				

				if(key[KEY_C]){
					map->CleanUp();
					keyPressCounter = 500;
				}
				else if(key[KEY_ENTER]){
					if(currentTileToPlace){
						map->SetTile(cursorX,cursorY,currentTileToPlace->GetName());
					}
				}
				else if(key[KEY_DEL]){
					map->RemoveTile(cursorX,cursorY);
				}
				else if(key[KEY_X]){
					map->Erase();
					keyPressCounter = 1000;
				}
			}

			if(key[KEY_PGDN]){
				keyPressCounter = 150;
				if(mode==DRAWING_TILES){
					map->GetTileSet()->NextTile(&tileIterator);
					currentTileToPlace = map->GetTileSet()->GetTileAt(tileIterator);
				}
				else if(mode==PLACING_ENEMY){
					map->GetTileSet()->NextEnimDef(&enimDefIterator);
					enimToPlace = map->GetTileSet()->GetEnimDefAt(enimDefIterator);
				}
			}
			else if(key[KEY_PGUP]){
				if(mode==DRAWING_TILES){
					map->GetTileSet()->PrevTile(&tileIterator);
					currentTileToPlace = map->GetTileSet()->GetTileAt(tileIterator);
					keyPressCounter = 150;
				}
				else if(mode==PLACING_ENEMY){
					map->GetTileSet()->PrevEnimDef(&enimDefIterator);
					enimToPlace = map->GetTileSet()->GetEnimDefAt(enimDefIterator);
				}
			}

			if(key[KEY_S]){
				map->Save();
				keyPressCounter = 500;
			}

			if(key[KEY_SPACE]){
				keyPressCounter = 500;
				if(mode==DRAWING_TILES){
					mode = PLACING_ENEMY;
					enimToPlace = map->GetTileSet()->GetEnimDefAt(enimDefIterator);
				}
				else if(mode==PLACING_ENEMY){
					mode = PLACING_DECORATIONS;
					decorationToPlace = map->GetTileSet()->GetDecorationDefAt(decorationDefIterator);
				}
				else if(mode==PLACING_DECORATIONS)
					mode = DRAWING_TILES;
				
			}

			
		}
	}

	if(keyPressCounter>0){
		keyPressCounter-=msecPassed;
		if(keyPressCounter<0)
			keyPressCounter=0;
	}

	if(mode!=DRAWING_TILES){
		if(key[KEY_LEFT] || mouse_x < 30){
			actorPlacementCameraX-= 0.5f * msecPassed;
		}
		else if(key[KEY_RIGHT] ||  mouse_x > Constants::BACKGROUND_WIDTH-30){
			actorPlacementCameraX+=0.5f * msecPassed;
		}

		if(key[KEY_UP] || mouse_y < 30){
			actorPlacementCameraY-=0.5f * msecPassed;
		}
		else if(key[KEY_DOWN] || mouse_y > Constants::BACKGROUND_HEIGHT-30){
			actorPlacementCameraY+=0.5f * msecPassed;
		}

		if(actorPlacementCameraX < Constants::BACKGROUND_WIDTH/2)
			actorPlacementCameraX = Constants::BACKGROUND_WIDTH/2;
		if(actorPlacementCameraY < Constants::BACKGROUND_HEIGHT/2)
			actorPlacementCameraY = Constants::BACKGROUND_HEIGHT/2;
	}

	actorUnderMouse = map->CheckCollisionWithActor(mouse_x + camera->GetX() , mouse_y + camera->GetY(),msecPassed);
	if(mouse_b&1){
		if(!mouseButtonPressed){
			mouseButtonPressed = true;

			if(mode==PLACING_ENEMY || mode==PLACING_DECORATIONS){
				if(actorUnderMouse!=0){
					draggingActor = true;
					actorBeingDragged = actorUnderMouse;
				}
			}
		}
	}
	else{
		if(mouseButtonPressed){
			mouseButtonPressed=false;
				
			if(mode==PLACING_ENEMY || mode==PLACING_DECORATIONS){
				if(draggingActor){
					draggingActor = false;
				}
				else{
					if(mode==PLACING_ENEMY){
						map->AddEnemy(enimToPlace, enimDir, mouse_x+camera->GetX(), mouse_y+camera->GetY());
					}
					else if(mode==PLACING_DECORATIONS){
						map->AddDecoration(decorationToPlace,mouse_x+camera->GetX(), mouse_y+camera->GetY());
					}
				}
			}

		}
	}

	if(mouse_b&2){
		enimDir = Character::FACING_RIGHT;
	}
	else
		enimDir = Character::FACING_LEFT;

	if( (mode==PLACING_ENEMY || mode==PLACING_DECORATIONS) && draggingActor && actorBeingDragged!=0){
		actorBeingDragged->SetPosition(mouse_x + camera->GetX() , mouse_y + camera->GetY());
	}
	
	
}

int MapEditor::GetCameraFocusX(){
	if(mode==DRAWING_TILES){
		return cursorX*TILE_WIDTH;
	}
	else{
		return actorPlacementCameraX;
	}
}

int MapEditor::GetCameraFocusY(){
	if(mode==DRAWING_TILES){
		return cursorY*TILE_HEIGHT;
	}
	else{
		return actorPlacementCameraY;
	}
}