#include "Image.h"

Image::Image(const char *namechar, const char *imgFilename) : Resource(namechar)
{
	Log::inst()->logLine("Creating image. Name: ["+(*name)+"]");
	BITMAP *temp = load_bitmap(imgFilename,0);
	if(temp)
	{
#ifdef USE_VIDEO_BITMAPS
		bmp = create_video_bitmap(temp->w,temp->h);
		blit(temp,bmp,0,0,0,0,bmp->w,bmp->h);
		destroy_bitmap(temp);
#else
		bmp = temp;
#endif
	}
	else{
		Log::inst()->logLine("error loading image at " + std::string(imgFilename) + ".");
	}
}

Image::~Image(void)
{
	destroy_bitmap(bmp);
}

void Image::Draw(BITMAP *dest, int x, int y){
	if(bmp){
		draw_sprite(dest,bmp,x,y);

	}
}

void Image::DrawFlipped(BITMAP *dest, int x, int y){
	if(bmp){
		draw_sprite_h_flip(dest,bmp,x,y);
	}
}
