#pragma once
#include <vector>
#include <allegro.h>
#include "Resource.h"
#include "AnimDef.h"

class EnimDef :
	public Resource
{
public:
	static const int ELF=0;

	bool walks;
	bool throws;
	bool jumps;

	float jumpSpeed;
	float walkSpeed;
	float maxWalkSpeed;
	int readyToJumpTime;	//time it takes after landing before you can jump again (in msec)
	int readyToThrowTime;	//time it takes after throwing a projectile before you can throw another (min msec)
	float maxThrowPower;


	int type;
	std::vector<AnimDef*> animDefs;
	Rectangle hitBox;

	EnimDef(const char* name);
	~EnimDef(void);

	void AddAdnimDef(AnimDef* animDef);
	void DrawAt(BITMAP *dest, int x, int y, bool flipped);
};
