#include "EnimDef.h"

EnimDef::EnimDef(const char* name) : Resource(name)
{
}

EnimDef::~EnimDef(void)
{
}

void EnimDef::AddAdnimDef(AnimDef* animDef){
	animDefs.push_back(animDef);
}

void EnimDef::DrawAt(BITMAP *dest, int x, int y, bool flipped){
	rect(dest, x+hitBox.x, y+hitBox.y, x+hitBox.x+hitBox.w, y+hitBox.y+hitBox.h,makecol(255,0,0));

	if( animDefs.size()>0 && animDefs[0] ){
		AnimDef *def = animDefs[0];

		if(flipped){
			def->GetFrame(0)->img->DrawFlipped(dest,x,y);
		}
		else
		{
			def->GetFrame(0)->img->Draw(dest,x,y);
		}
	}
}
