#pragma once
#include "Constants.h"
#include "ResourceManager.h"
#include "Actor.h"
#include "Log.h"
#include "Projectile.h"
#include "ProjectileList.h"

class Character :
	public Actor
{
protected:


	float jumpSpeed;
	float walkSpeed;
	float maxWalkSpeed;
	int readyToJumpTime;	//time it takes after landing before you can jump again (in msec)
	int readyToJumpCounter;
	int dir;

	int readyToThrowTime;	//time it takes after throwing a projectile before you can throw another (min msec)
	int readyToThrowCounter;

	float currentThrowPower;
	float maxThrowPower;
	float startingThrowPower;
	bool currentlyThrowing;
	bool throwPowerIncreasing;

	int type;		//used to determine if a given projectile should do damage
	bool walking;

public:
	static const int PLAYER=0;
	static const int ENEMY=1;

	static const int FACING_LEFT=0;
	static const int FACING_RIGHT=1;

	Character(Rectangle hitBox, int type);
	~Character(void);

	void Reset();
	virtual void Jump(int msecPassed);
	virtual void WalkLeft();
	virtual void WalkRight();

	void ClearForces();

	float GetCameraFocusX();
	float GetCameraFocusY();
	int GetDir() { return dir; } 
	virtual void SetPosition(float x, float y, int dir=-1);
	virtual int ThrowLocationX() { return hitBox.w/2; }
	virtual int ThrowLocationY() { return 0; }

	void Draw(BITMAP *dest, int screenx, int screeny);
	void Update(int msecPassed,Map *map);
	virtual void ModifyAnimation() = 0;

	void IncreaseThrowPower(int msecPassed);
	virtual void StartThrowingProjectile(int msecPassed, ProjectileList *projList);
	virtual void ThrowProjectile(int msecPassed, ProjectileList *projList);

	void CheckCollisionWithProjectiles(ProjectileList *projList, int msecPassed);

	virtual void HitByProj(Projectile *proj, int msecPassed) = 0;
};
