#include "Anim.h"

Anim::Anim(AnimDef *animDef)
{
	this->animDef = animDef;
	running = true;
	SetFrame(0);
	timeLeft = 0;
	loop = true;
	finished = false;
}

Anim::~Anim(void)
{
}

void Anim::Draw(BITMAP *dest, int x, int y){
	if(currentFrame && currentFrame->img){
		currentFrame->img->Draw(dest,x + currentFrame->offsetX, y+currentFrame->offsetY);
	}
}

void Anim::DrawFlipped(BITMAP *dest, int x, int y){
	if(currentFrame && currentFrame->img){
		currentFrame->img->DrawFlipped(dest,x + currentFrame->offsetX, y+currentFrame->offsetY);
	}
}

void Anim::Update(int msecPassed){
	if(animDef && running){
		timeLeft-=msecPassed;
		if(timeLeft<=0){
			NextFrame();
		}
	}
}

void Anim::NextFrame(){
	curFrameIndex++;
	if(curFrameIndex>=animDef->CountFrames()){
	if(loop){
		curFrameIndex %= animDef->CountFrames();
	}
	else{
		curFrameIndex = animDef->CountFrames()-1;
		if(curFrameIndex<0) curFrameIndex=0;
			running=false;
			finished = true;
		}
	}

	AnimFrame *frame = animDef->GetFrame(curFrameIndex);
	if(frame){
		timeLeft=frame->duration;
		currentFrame = frame;
	}

}

void Anim::SetFrame(int n){
	curFrameIndex = n;
	if(animDef){
		currentFrame = animDef->GetFrame(curFrameIndex);
		finished = false;
	}
}

void Anim::Reset(){
	if(animDef){
		SetFrame(0);
		finished = false;
	}
}

void Anim::Stop(){
	if(animDef){
		running = false;
		finished = false;
		Reset();
	}
}

void Anim::Start(bool loop){
	if(animDef){
		this->loop = loop;
		running = true;
		finished = false;
	}
}

void Anim::Pause(){
 	if(animDef){
		running = false;
		finished = false;
	}
}
