#pragma once
#include <vector>
#include <cstdlib>
#include <math.h>

#include <allegro.h>
#include "Constants.h"
#include "Anim.h"

class Map;

class Actor
{
private:
	std::vector<Anim> animations;


	float accelX, accelY;
	bool isOnGround;
	bool isHittingLeft, isHittingRight;
	
	bool bounces;

	float currentSurfaceFriction;
	unsigned int currentAnim;

	void MoveUp(Map *map, float targetX, float targetY);
	void MoveDown(Map *map, float targetX, float targetY);
	void MoveLeft(Map *map, float targetX, float targetY);
	void MoveRight(Map *map, float targetX, float targetY);

protected:
	bool moveable;
	Rectangle hitBox;
	float x,y;
	float velX, velY;

public:
	Actor(Rectangle hitBox, bool moveable, bool bounces=false);
	virtual ~Actor(void);

	virtual void Reset();

	void AddAnimation(AnimDef* animDef);
	float GetX(){return x;}
	float GetY(){return y;}
	float GetCentreX() { return x+hitBox.w/2;}
	float GetCentreY() { return y+hitBox.h/2;}
	float GetVelX() { return velX; }
	float GetVelY() { return velY; }

	virtual float GetCameraFocusX() {return GetCentreX();}
	virtual float GetCameraFocusY() {return y;}
	Anim* GetCurrentAnim();
	unsigned int GetCurrentAnimIndex() { return currentAnim; }
	void SetCurrentAnim(unsigned int index);
	

	virtual void Draw(BITMAP *dest, int screenx, int screeny, bool flip=false);
	virtual void Update(int msecPassed,Map *map);
	void EnforceMaxXSpeed(float speed);

	virtual void SetPosition(float x, float y, int dir=-1) { this->x = x; this->y = y;}


	virtual void ClearForces();
	void ApplyForce(float fx, float fy);
	

	bool CheckCollisionWithMap(int positionX, int positionY, Map *map);

	bool IsOnGround();
	bool IsMoveable(){ return moveable;}
	bool IsHittingLeft() {return isHittingLeft; }
	bool IsHittingRight() {return isHittingRight; }

	void ModifyVel(float deltax, float deltay);
	void SetVel(float x, float y) { velX = x; velY = y; }

	float GetCurrentSurfaceFriction(){ return currentSurfaceFriction; }

	bool CheckCollision(Actor *other, int msecPassed);
	bool CheckCollision(int px, int py, int msecPassed);
};
